#include <stdio.h>
#include <unistd.h>
#include <malloc.h>
#include <sys/mman.h>
#include <linux/unistd.h>
#include <linux/mman.h>

_syscall2(int, mlock, const void *, addr, size_t, len)
_syscall2(int, munlock, const void *, addr, size_t, len)
_syscall1(int, mlockall, int, how)
_syscall0(int, munlockall)

#define PAGESIZE 4096

#define KBYTE 1024
#define MBYTE KBYTE*KBYTE
#define SIZE 1*MBYTE

#define show_vma()	mlockall( MCL_VMA )
#define show_process()	mlockall( MCL_PROCESS )
#define show_memory()	mlockall( MCL_MEMORY )

unsigned char test[SIZE];

void main()
{
  int ret,i;

  show_memory();
  show_vma();

  ret = mlock( test, 2*PAGESIZE );
  if( ret == -1 ) perror("mlockall");

  show_memory();
  show_vma();

  ret = munlock( test, PAGESIZE );
  if( ret == -1 ) perror("munlockall");

  show_memory();
  show_vma();

  if(fork()) {
    /* father */
    show_memory();
    show_vma();
  }
  else {
    /* child */
    show_memory();
    show_vma();
  }

  sleep(10);

}
