
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <stdio.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>

#include "misc.h"
#include "node.h"

static char file_name[100];
static FILE *status_file;

static char buffer[82];

int
read_user_menurc()
{
	struct stat stat_buf;
	FILE *status_file;

	/* read the user's .menurc file, get short cuts, etc. */
	/* return: 0 if can't read the file, 1 if read */

	strcpy( file_name, user_home );
	strcat( file_name, "/.menurc" );
	if( stat( file_name, &stat_buf ) != 0 ) {
		intro_message();
		/* create null status_file */
		status_file = fopen( file_name, "w" );
		fclose( status_file );
		return 0;
	}

	if( stat_buf.st_size == 0 ) return 0;

	status_file = fopen( file_name, "r" );
	if( status_file == NULL ) return 0;

	fgets( buffer, 80, status_file );
	if( strncmp( buffer, "UCLink Menu System", 18 ) != 0  ) {
		warn("Unrecognized Initial Line in .menurc - file ignored\n");
		return 0;
	}
	read_defaults( status_file );
	fclose( status_file );
	return(1);
}

read_defaults( stream )
FILE *stream;
{
	char letter;
	char *ptr;
	char *strchr();
	int node_number;
	int need_new_menurc = 0;

	while( fgets( buffer, 80, stream ) != NULL
				&& strncmp( buffer, "End", 3 ) != 0 ) {
		if( buffer[0] == '#' ) continue;
		if( strncmp( buffer, "ShowIntro", 9 ) == 0  ) {
			need_new_menurc = 1;
			continue;
		}
		if( strncmp( buffer, "ShortCut: ", 10 ) != 0
				|| !isalpha(buffer[10]) 
				|| buffer[11] != ' '
				|| !isalpha(buffer[12]) ) {
			printf("%s\n", buffer );
			warn("unrecognized line in .menurc deleted" );
			need_new_menurc = 1;
			continue;
		}
		letter = buffer[10];
		for( ptr = &buffer[12]; !isspace(*ptr) && *ptr != '\0'; ptr++ );
		*ptr = '\0';
		if( (node_number = find_node( &buffer[12] )) < 0 ) {
			bad_short_cut( letter );
			need_new_menurc = 1;
			continue;
		}
		if( sc_map[ letter ] < -1 ) {
			bad_short_cut( letter );
			need_new_menurc = 1;
			continue;
		}
		add_short_cut( node_number, letter );
	}
	if( need_new_menurc ) save_status();
}

bad_short_cut( letter )
char letter;
{
	char warn_message[100];

	sprintf( warn_message,
		" predefined short cut for '%c' invalid & deleted\n",
			letter );
	warn( warn_message );
}

warn( message )
char *message;
{
	printf("*** %s\n", message );
	sleep(2);
}

save_status()
{
	char letter;

	/* stupid - need to truncate in case what we are writing
	 * is less than was there already
	 *
	 * since we are running quotas, truncating to 0 might
	 * throw away all blocks, so truncate to 1 to keep a block?
	 */
	truncate( file_name, 1 );

	status_file = fopen( file_name, "w" );
	if( status_file == NULL ) return;


	fprintf( status_file, "UCLink Menu System Version: %s\n", version );

	for( letter = 'A'; letter < 'z'; letter++ ) {
		if( isalpha( letter ) && sc_map[ letter ] >= 0 ) {
			fprintf( status_file, "ShortCut: %c %s\n",
					letter, node[sc_map[letter]]->nd_label);
		}
	}
	fprintf( status_file, "End\n" );
	fclose( status_file );
}
