
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <stdio.h>

#include "actions.h"
#include "curses.h"
#include "getch7.h"
#include "log.h"
#include "menu.h"
#include "misc.h"
#include "run_menu.h"

#define ESC 033

int
read_and_move( menu )
MENU *menu;
{
	int ch;
	int line_no;
	int action;

	raw();
	GETCH7( ch );

	/* check for short cut */
	if( isalpha( ch) && sc_map[ ch ] >= 0 ) {
		short_cut_node = sc_map[ ch ];
		return( ACTION_SHORT_CUT );
	}

	if( ch == ESC ) {
		GETCH7( ch );
		if( ch == '[' ) {
			GETCH7( ch );
			switch ( ch ) {
			/* for arrows, set to vi equivalents */
			case 'A':	ch = 'k'; break;
			case 'B':	ch = 'j'; break;
			case 'C':	ch = 'l'; break;
			case 'D':	ch = 'h'; break;
			default:  ring_bell();
			}
		}
	} else if ( isdigit(ch) ) {
		ch = jump( ch, menu, JUMP_NUMBER );
	} else if ( ch == '/' ) {
		ch = jump( ch, menu, JUMP_SEARCH );
	}
	noraw();

	action = ACTION_NONE;
	switch ( ch ) {
		/* down: j, ^j, ^n (pico users), down arrow */
		case 'j':
		case 012: /* cntrl-j */
		case 016: /* cntrl-n - pico usage */
		case 026: /* down arrow on tvi925 */
			if(cur_line_no < menu->mn_nrows-1) {
				arrow_move( cur_line_no,
						cur_line_no+1);
				cur_line_no++;
			} else {
				arrow_move( cur_line_no, 0 );
				cur_line_no = 0;
			}
			break;
		/* up: k, ^k, ^p (pico users), up arrow */
		case 'k':
		case 013:
		case 020:
			if( cur_line_no > 0 ) {
				arrow_move( cur_line_no,
						cur_line_no-1);
				cur_line_no--;
			} else {
				arrow_move( cur_line_no, menu->mn_nrows-1 );
				cur_line_no = menu->mn_nrows-1;
			}
			break;
		/* left: u, h, ^h, ^b (pico users), left arrow */
		case 'u':
		case 'h':
		case 010:
		case 002:
			action = ACTION_EXIT;
			break;
		/* right: l, ^f (pico users), right arrow, return */
		case 'l':
		case 006:	/* control-f (pico) */
		case '\r':
			action = ACTION_ENTER;
			break;
		/* add the item to the left of the cursor to short cut list */
		case 'a':
			if( !in_short_cut_menu ) {
				action = ACTION_ADD_ITEM;
			} else {
				ring_bell();
			}
			break;
		/* add current menu to short cut list */
		case 'A':
			if( !in_short_cut_menu ) {
				action = ACTION_ADD_MENU;
			} else {
				ring_bell();
			}
			break;
		/* delete a sort cut */
		case 'd':
			if( in_short_cut_menu && cur_line_no > 0 ) {
				action = ACTION_DELETE_ITEM;
			} else {
				ring_bell();
			}
			break;
		/* Quit */
		case 'q':
			if( check_quit() ) {
				action = ACTION_QUIT;
				break;
			} else {
				bottom_line();
				break;
			}
		case 'Q':
			action = ACTION_QUIT;
			break;
		/* redraw the screen: ^r or ^l */
		case 022:
		case 014:
			action = ACTION_REDRAW;
			break;
		case 'v':
			if( !in_short_cut_menu ) {
				action = ACTION_VIEW_SHORT_CUTS;
			} else {
				ring_bell();
			}
			break;
		/* go to main/top menu */
		case 'm':
			action = ACTION_MAIN;
			break;
		case '?':
			action = ACTION_HELP;
			break;
		case '*':
			action = ACTION_LINE_HELP;
			break;
		case EOF:
			log( 'T', "EOF" );
			die();
		default:
			ring_bell();
			;
	}
	return( action );
}
