
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <stdio.h>
#include <unistd.h>

#include "log.h"
#include "misc.h"
#include "node.h"

/*	write log of what user did */

int logging;

static FILE *log_file;
static char log_file_name[100];
static int time_stamp_start;
static char time_ascii[26];

static char *log_base_ptr;
static char *log_cur_ptr;
static char *log_end_ptr;

static int  log_count;
static int  lch;

#define LOG_BUFFER_LEN 2000

log_init()
{
	/*
	 *	set "logging" to 1 if logging is on, 0 otherwise
	 *	if on:
	 *		save initial timestamp,
	 *		set up buffer to save logged items,
	 *		get log file name.
	 */

	char *malloc();
	char temp[30];
	char *ctime();

	/* check if logging - if file  base_dir/logs/Menu_logging  exists */
	strcpy( log_file_name, base_dir );
	strcat( log_file_name, "/logs/Menu_logging" );

	logging = ( access( log_file_name, F_OK ) == 0 );
	if( !logging ) return;

	/* logging - save initial time */
	time( &time_stamp_start );

	strcpy( temp, ctime( &time_stamp_start ) );
	temp[16] = '\0';
	strcpy( time_ascii, temp + 4 );

	/* get buffer for logging info */
	log_base_ptr = malloc( LOG_BUFFER_LEN + LAB_LEN + 2 );
	if( log_base_ptr == NULL ) {
		logging = 0;
		return;
	}
	log_cur_ptr = log_base_ptr;
	log_end_ptr = log_base_ptr + LOG_BUFFER_LEN;

	/* create log file name */
	strcpy( log_file_name, base_dir );
	strcat( log_file_name, "/logs/" );
	strncat( log_file_name, user_logon, 1 );

	/* last char. of logon */
	lch = user_logon[strlen(user_logon)-1];

	log( 'B', "begin" );

	return;
}

log_end()
{
	int time_stamp_end;
	int interval;
	char interval_string[10];

	if( logging == 0 ) return;

	time( &time_stamp_end );
	interval = time_stamp_end - time_stamp_start;
	sprintf( interval_string, "%6.6d/%5.5d", interval, log_count );
	log( 'E', interval_string );
	/* flush the buffer */
	log( '\0', " " );
}


/* log() is a macro for:
		if( logging ) log_item( ..., ... )
*/

/*
 * current "ch" values:
 *	a, A, d: adding/deleting shortcuts
 *	+:	 using shortcut
 *	?,*:	 help
 *	M:	 enter menu
 *	C:	 command
 *	B,E:	 begin/end
 *	T:	 terminate via EOF, ERR (too many errors), HUP (sighup)
 */

log_item( ch, string )
char ch, *string;
{
	int len = strlen( string );

	if( logging == 0 ) return;

	/* count how many items logged */
	log_count++;

	if( log_cur_ptr + len + 5 > log_end_ptr  ||  ch == '\0' ) {
		/* can't fit the entry, write the buffer and start anew */
		log_file = fopen( log_file_name, "a" );
		if( log_file == NULL ) {
			logging = 0;
			return;
		}
		fprintf( log_file, "%c>:%s %s\n%s%c<:\n",
			lch, user_logon, time_ascii, log_base_ptr, lch );
		fclose( log_file );
		log_cur_ptr = log_base_ptr;
	}

	/*
	 * format of each item in the log is:
	 *	LX:String\n,
	 * where "L" is the last letter of the logon
	 * "X" is the letter, "String" is a string, usually the
	 * label for the node.
	 *
	 * put in last letter of logon, 'cause name of file is first
	 * letter & may have intermixed log records, so with this,
	 * we can check (if we care).
	 */
	log_cur_ptr[0] = lch;
	log_cur_ptr[1] = ch;
	log_cur_ptr[2] = ':';
	strcpy( log_cur_ptr + 3, string );
	log_cur_ptr += len + 3;
	*log_cur_ptr++ = '\n';
	*log_cur_ptr = '\0';
}
