
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <curses.h>
#include <stdio.h>

#include "getch7.h"
#include "log.h"
#include "misc.h"
#include "node.h"

#define MAX_LINES 16
static char *lines[MAX_LINES+1];

extern MENU *current_menu;

line_help( node_num, menu )
int node_num;
MENU *menu;
{
	char title[100];
	NODE *node_ptr;

	node_ptr = node[node_num];

	log( '*', node[node_num]->nd_label );

	strcpy( title, node_ptr->nd_title );
	title[strlen(title)-1] = ':';

	display_text( title, node[node_num]->nd_label, menu );
}

static int parity_errs;

non_ascii()
{
	if( parity_errs++ < 6 ) {
		log( 'P', "parityerr" );
		display_text( NULL, "non_ascii", current_menu );
	}
}

static
display_text( title, label, menu )
char *title;
char *label;
MENU *menu;
{
	FILE *stream;
	char help_file_name[100];
	char *strchr();
	char *malloc();
	int line_no;
	int nlines;
	int index;
	int ignore;

	strcpy( help_file_name, base_dir );
	strcat( help_file_name, "/etc/help/" );
	strcat( help_file_name, label );

	raw();
	stream = fopen( help_file_name, "r" );
	if( stream != NULL ) {
		for( line_no = 0; line_no < MAX_LINES; line_no++ ) {
			if( lines[line_no] == NULL ) {
					lines[line_no] = malloc(81);
			}
			if( fgets( lines[line_no], 79, stream ) == NULL ) break;
			/* put in a '\n' in case too long and none read */
			lines[line_no][78] = '\n';
			*(strchr(lines[line_no],'\n')) = '\0';
		}
		nlines = line_no;
		fclose( stream );
	} else {
		if( lines[0] == NULL ) lines[0] = malloc(81);
		strcpy( lines[0], "Sorry, no additional information is available.");
		nlines = 1;
	}

	index = LINES - 5 - nlines;
	move( index, 0 );
	clrtobot();
	index++;
	move( index, 0 );
	if( title != NULL ) {
		addstr( title );
	}

	index++;

	for( line_no = 0; line_no < nlines; line_no++ ) {
		index++;
		mvaddstr( index, 0, lines[line_no] );
	}
	mvaddstr( LINES - 1, 0, "Press any key to continue. " );
	clrtoeol();
	refresh();

	/* don't use GETCH7; if did, might have recursion problems */
	ignore = getch();

	/*
	 * see if menu & help overlap, if so need full redraw.
	 * menu takes n+4 lines, help takes n+5
	 */
	if( menu->mn_nrows + nlines + 9 > LINES ) {
		display_menu( menu );
	} else {
		move( LINES - nlines - 5, 0 );
		clrtobot();
		bottom_line();
		arrow_draw( cur_line_no );
	}
	noraw();
}
