
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <curses.h>

#include "getch7.h"
#include "menu.h"
#include "misc.h"
#include "run_menu.h"

jump( ch, menu, type )
char ch;
MENU *menu;
int type;
{
	int line_no;
	int i;
	char temp[100];
	char *ptr;
	char *get_input();

	move( LINES - 1, 0 );
	clrtoeol();
	if( type == JUMP_NUMBER ) {
		/* user is specifying a line number.
		 * prompt at bottom of screen with current digit in case
		 * line number is two digits.
		 */
		strcpy( temp, "Move To Line: " );
		i = strlen( temp );
		temp[ i ] = ch;
		temp[ i + 1 ] = '\0';
		ptr = get_input( temp );
		temp[0] = ch;
		temp[1] = '\0';
		if( ptr != NULL ) strcat( temp, ptr );
		line_no = atoi( temp );
		/* input was 1...mn_rows, internal is 0...mn_rows - 1 */
		line_no--;
		ch = '\r';
	} else if( type == JUMP_SEARCH ) {
		/* user is specifying a line number.
		 * prompt at bottom of screen with current digit in case
		 * line number is two digits.
		 */
		ptr = get_input( "Search string: " );
		ch = '\r';
		if( ptr != NULL ) {
			line_no = search_menu( ptr );
		} else {
			line_no = cur_line_no;
		}
	}

	/* prompt was on bottom line - restore normal line */
	bottom_line();
	/* silly to erase and redraw, but I can't figure
		out how to move the cursor on the screen
		otherwise */
	arrow_erase( cur_line_no );
	arrow_draw( cur_line_no );

	if( line_no >= 0 && line_no < menu->mn_nrows ) {
		arrow_move( cur_line_no, line_no );
		cur_line_no = line_no;
	} else {
		ring_bell();
		/* signal error to next section */
		ch = 0177;
	}
	return( ch );
}

