
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <curses.h>
#include <signal.h>
#include <stdio.h>

#include "log.h"
#include "menu.h"

extern int curses_active;

die()
{
	if( curses_active ) curses_end();
	log_end();
	exit_messages();
	endit( 1 );
}

endit( status )
int status;
{
	reset_sigs();
	restore_suspend();
	exit( status );
}

die_sighup()
{
	log( 'T', "SIGHUP" );
	die();
}

set_sigs()
{
	signal( SIGINT, SIG_IGN );
	signal( SIGQUIT, SIG_IGN );
	signal( SIGTSTP, SIG_IGN );
	signal( SIGHUP, die_sighup );
}

reset_sigs()
{
	signal( SIGINT, SIG_DFL );
	signal( SIGQUIT, SIG_DFL );
	signal( SIGTSTP, SIG_DFL );
	signal( SIGHUP, SIG_DFL );
}
