
/*
 * Copyright 1993, 1994, 1995 by the Regents of the University of California
 * see the file "Copyright" in the distribution for conditions of use.
 */

#include <curses.h>
#include <stdio.h>

#include "menu.h"

extern int curses_active;

curses_start()
{
	/* initscr() succeeds unless no memory */
	if( initscr() == (WINDOW *) NULL ) die();
	curses_active = 1;
	noecho();
	/* manual recommends this - not mapping CR to LF - to
		allow greater optimization of cursor motion */
	/* For some wierd reason, Linux doesn't like the below line.
           The line below makes the screen appear wierd, at least 
           under my version of ncurses and Linux.  Because of this, we
           will only enable nonl() mode when a character input is 
           asked for.  Also see getch7.h for more information. */

#ifdef BROKEN_CURSES
	nonl();
#endif /* BROKEN_CURSES */

	/* don't leave cursor after last change - move it to (y,x) */
	leaveok(stdscr,FALSE);
	scrollok(stdscr,FALSE);
}

curses_end()
{
	clear();
	mvcur(0,COLS-1,LINES-1,0);
	clrtoeol();
	refresh();
	mvcur(0,COLS-1,LINES-1,0);
	endwin();
	printf("\n");
	curses_active = 0;
}
