// Copyright 1994 Brad Pitzel
//
// Feel free to use/distribute/modify as long as credit/copyrights for myself 
// are included.

#ifndef __Explos__
#define __Explos__

#include <stdlib.h>
#include <math.h>
#include <vgagl.h>

#include "ObjTools.h"
#include "PtrList.h"
#include "FastMath.h"

class TrajPoint : public Trajectory
	{
	public:
	
	TrajPoint( unsigned char color=0, FixedPoint Fxp=0, FixedPoint Fyp=0 )
		: Vcolor(color), Trajectory(Fxp,Fyp) 
		{
		};

	unsigned char Vcolor;
	};

#define BMAX	200
//////////////////////////////////////////////////////////////////////////////
class Explosion : public Life {
    public:
    	Explosion( FixedPoint Fxp, FixedPoint Fyp, int size, int duration, 
    	           FixedPoint Fxvel=0, FixedPoint Fyvel=0);
    	           
	inline void draw() const
		{
		register int i;
		TrajPoint *p=Vbit;

		for(i=0;i<Vsize;i++) 
			{
			gl_setpixel( FP2INT(p->VFx), FP2INT(p->VFy), 
			             p->Vcolor );
			p++;
			}
		}

	inline void tick()
		{
		register int i;
		TrajPoint *p=Vbit;

		for(i=0;i<Vsize;i++) (p++)->moveNoWrap();

		Life::tick();
		}
	    
    private:
	TrajPoint	Vbit[BMAX];
	int		Vsize;

    };


//////////////////////////////////////////////////////////////////////////////
class Boom
    {
    public:
    	
	static void add( FixedPoint Fxp, FixedPoint Fyp, 
	                 int size, int duration, 
    	                 FixedPoint Fxvel=0, FixedPoint Fyvel=0)
    		{
    	        list.add(new Explosion( Fxp, Fyp,
    	                                size, duration,
    	                                Fxvel, Fyvel ));
    		}
	
    	static void tick();
	static void draw();
	static void die() { list.removeAll(); }
		
    private:
    
	static PtrList<Explosion>	list;
    };
    
#endif
