/* #module    GloMiss    "2-001"
 ***********************************************************************
 *                                                                     *
 * The software was developed at the Monsanto Company and is provided  *
 * "as-is".  Monsanto Company and the auther disclaim all warranties   *
 * on the software, including without limitation, all implied warran-  *
 * ties of merchantabilitiy and fitness.                               *
 *                                                                     *
 * This software does not contain any technical data or information    *
 * that is proprietary in nature.  It may be copied, modified, and     *
 * distributed on a non-profit basis and with the inclusion of this    *
 * notice.                                                             *
 *                                                                     *
 ***********************************************************************
 */
/*
 * Module Name:	GloMiss
 *
 * Author:	R L Aurbach	CR&DS MIS Group    22-Aug-1986
 *
 * Function:
 *	Report those labels for which no glossary entry was found.
 *
 * Modification History:
 *
 * Version     Initials	   Date		Description
 * ------------------------------------------------------------------------
 * 1-001	RLA	22-Aug-1986	Original Code
 * 2-001	F.H.	17-May-1991	converted to portable C
 */
/*
 * Module GloMiss - Module-Wide Data Description Section
 *
 * Include Files:
 */
#ifdef MSDOS
#include <stdlib.h>
#include <io.h>
#define F_OK		0	/* access(): File exists	*/
#else
#include <sys/file.h>
/* extern char *sprintf(); */
#endif
#include <string.h>
#include <stdio.h>
#include "GloDef.h"
/*
 * Module Definitions:
 */
/*
 * Global Declarations:
 */
#ifdef MSDOS
int	Glo_Report_Missing(void);
#else
int	Glo_Report_Missing();
#endif
/*
 * Static Declarations:
 */
/*
 * External References:
 */
extern STRING_PTR	    labels;
extern char		    infile[256];
/*
 * Functions Called:
 */
/*
 * Function Glo_Report_Missing - Documentation Section
 *
 * Discussion:
 *	Report the labels for which no definition has been found in any
 *	glossary definition file.  The report is made both to SYS$OUTPUT and
 *	to a glossary log file (.glg file).
 *
 * Calling Synopsis:
 *	status = Glo_Report_Missing ()
 *
 * Inputs:
 *	none
 *
 * Outputs:
 *	none
 *
 * Return Value:
 *	status	    ->	is a boolean integer.  It indicates success or
 *			failure of the operation.
 *
 * Global Data:
 *	none
 *
 * Files Used:
 *	none
 *
 * Assumed Entry State:
 *	none
 *
 * Normal Exit State:
 *	status == TRUE	    success.
 *
 * Error Conditions:
 *	status == FALSE	    failure
 *
 * Algorithm:
 *	A. Open the output file.
 *	B. For each leaf in the labels list,
 *	    1. Report the value of the label.
 *
 * Special Notes:
 *	none
 */
/*
 * Function Glo_Report_Missing - Code Section
 */
int	Glo_Report_Missing ()
{
/*
 * Local Declarations
 */
  STRING_PTR	    token;
  char	    dna[256];
  FILE	    *f;
/*
 * Module Body
 */
  if (labels == 0)	return(TRUE);
/* Open the output file							    */
  (void)sprintf(dna, "%s.glg", infile);
  f = fopen(dna, "w");
  (void)fprintf(f,"GloTeX Log File\n\n");
  (void)fprintf(f,"Processing input file \'%s.glo\'\n\n", infile);
  token = labels;
  while (token != 0) {
    if ((strlen(token->desc)) > 0) {
      (void)printf("The label \'%s\' ", token->desc);
      (void)printf("was not found in any glossary definition file\n");
      (void)fprintf(f,"The label \'%s\' ", token->desc);
      (void)fprintf(f,"was not found in any glossary definition file\n");
    }
    token = token->next;
  }
  (void)fclose(f);
  return (TRUE);
}
