
/* Structure used to hold dialog values */
typedef struct Dialog {
    void   *backpointer;	/* The previous dialog */
    WINDOW *d;			/* The dialog */
    WINDOW *f;			/* The frame box */
    WINDOW *t;			/* The text */
} Dialog;

extern WINDOW *top_window;

char *input_dialog (char *header, char *text, char *def_text);
char *input_expand_dialog (char *header, char *text, char *def_text);
int message (int error, char *header, char *text, ...);
int error (int status, int errnum, char *text,  ...);
void create_dialog (int cols, int rows, char *header, char *text, int error);
int query_dialog (char *header, char *text, int flags, int count, ...);
void destroy_dialog ();
void done_dialog ();

enum {
   D_NORMAL = 0,
   D_ERROR  = 1,
   D_INSERT = 2
} dialog_options;

WINDOW *get_top_text ();


/* The refresh stack */
typedef struct Refresh {
    void (*refresh_fn)();
    struct Refresh *next;
} Refresh;

void push_refresh (void (*new_refresh)());
void pop_refresh ();
void do_refresh ();
