/*
 *	pop3d		- IP/TCP/POP3 server for UNIX 4.3BSD
 *			  Post Office Protocol - Version 3 (RFC1081)
 *
 *	Katie Stevens
 *	dkstevens@ucdavis.edu
 * 	Computing Services
 *	University of California, Davis
 *
 **************************************
 *
 *	pop3.h
 *
 *	REVISIONS:
 *		02-27-90 [ks]	original implementation
 *	1.000	03-04-90 [ks]
 *	1.001	06-24-90 [ks]	allow TRANS state if 0 msgs in folder
 *				implement optional TOP command
 */
extern char *malloc();
extern char *realloc();
extern char *crypt();

/* In folder.c: */
extern int fld_bsmtp();
extern int fld_fromsp();

extern void fld_delete();
extern void fld_last();
extern void fld_list();
extern void fld_reset();
extern void fld_retr();
extern void fld_stat();
extern void fld_top();

extern void fld_release();

/* In util.c: */
extern int verify_user();
extern char *fgetl();
extern void cmd_prepare();
extern void fail();

#define SVR_LISTEN_STATE	0x00		/* Wait for client connection */
#define SVR_AUTH_STATE		0x01		/* Expecting USER command */
#define SVR_PASS_STATE		0x02		/* Expecting PASS command */
#define SVR_TRANS_STATE		0x03		/* Process mailbox commands */
#define SVR_FOLD_STATE		0x04		/* Need to open another mbox */
#define SVR_DONE_STATE		-1

#define SVR_TIMEOUT_CLI		600		/* 10 minutes */
#define SVR_TIMEOUT_SEND	120		/* 02 minutes */
#define SVR_BUFSIZ		1024
#define CLI_BUFSIZ		128

#define DEF_MAIL_DIR		"/usr/spool/mail/"
#define DEF_POP3_DIR		"/usr/spool/pop/"
#define POP3_TMPFILE		"/tmp/pop3XXXXXX"
#define POP3_RCPT_HDR		"X-POP3-Rcpt:"

#define BSMTP_HELO_STATE	0x00		/* Expecting HELO command */
#define BSMTP_MAIL_STATE	0x01		/* Expecting MAIL command */
#define BSMTP_RCPT_STATE	0x02		/* Processing RCPT cmds */
#define BSMTP_DATA_STATE	0x03		/* Processing message */

struct fld_item {
	long fmsg_entry;		/* Index in file of start of msg */
	long bcount;			/* #bytes this msg (for scan listing) */
	int status;			/* Status of this message */
#define MSG_DELETED	0x01			/* Msg marked for deletion */
	char *pop_hdr;			/* Extra header for POP3 client */
};
#define FLD_ENTRY_BLOCK		16
#define get_e_array(a,m) {\
	a = (struct fld_item *)malloc(sizeof(struct fld_item)*( (m) + 1));\
}
#define chk_e_size(a,m,i) {\
	if ( ( (i) ) && (!( (i) % (m) )) ) {\
		a = (struct fld_item *)realloc( (a), (sizeof(struct fld_item)*( (i) + (m) + 1)));\
	}\
}

#define DEBUG			1		/* set to 1 for debug file */
#define LOGFILE			"/var/adm/pop3d.log"

#define FAIL_CONFUSION		51		/* unknown error */
#define FAIL_FILE_ERROR		52		/* file read/write error */
#define FAIL_HANGUP		53		/* client hung up on us */
#define FAIL_LOST_CLIENT	54		/* timeout waiting for client */
#define FAIL_OUT_OF_MEMORY	55		/* out of system memory */
#define FAIL_PROGERR		56		/* unexpected program error */

#define NULL_CHAR	'\0'
#define LF_CHAR		'\n'
#define CR_CHAR		'\r'
#define DOT_CHAR	'.'
#define LANKLE_CHAR	'<'
#define RANKLE_CHAR	'>'

#define EATSPACE(s)	while (isspace(*s)&&(*s != NULL_CHAR)) ++s
