#include <unistd.h>
#include <stdio.h>
#include "file2.h"
#include "internal.h"
#include <trace.h>
/***************************************************************************
 *
 * Function:    fclose
 *
 * Description:
 *    Flush and close the stream.
 *
 * Input:
 *    stream   - pointer to the stream to be closed
 *
 * Output:
 *     0 to indicate that the file was closed successfully.
 *   EOF to indicate some error occured
 */

int fclose (FILE *stream)
    {
    int  nResult = EOF;
    FUNC_ENTRY ("fclose");
/*
 *  If the file is open and not a string file then flush the buffer and
 *  close the file.
 */
    if (inuse(stream) && !(stream->_flag & _IOSTRG))
        {
        nResult = fflush(stream);
        _freebuf(stream);

        if (close(fileno(stream)) >= 0)
	    {
            nResult = 0;
	    }
        }
/*
 *  Mark the file as being closed and return the result to the caller.
 */
    stream->_flag = 0;
    FUNC_EXIT ("fclose");
    return (nResult);
    }
