/*
 * Call Map -- if you can follow how this works, then you
 *	get a feeling of complexity that we are dealing with
 *	in this emulator.
 *
 * WARNING: It is entirely possible to create loops in these structures
 *          which will cause the kernel to hang either when attempting
 *          to resolve a syscall or when changing trace settings.
 *          Careful!
 *
 * $Id: callmap.inc,v 1.22 1994/05/23 07:58:58 mike Exp $
 * $Source: /var/CVS/ibcs/maps/callmap.inc,v $
 */

#define SC(name)	(void *)__NR_##name

#ifdef IBCS_TRACE
#  define ITR(trace, name, args)	,trace,name,args
#else
#  define ITR(trace, name, args)
#endif

/* ------------------------------------------------------------------ */

static IBCS_func Unused[] = {
   { 0,			Ukn	ITR(1, "?",	"")	},
   { 0,			Ukn	ITR(1, "?",	"")	},
   { 0,			Ukn	ITR(1, "?",	"")	},
   { 0,			Ukn	ITR(1, "?",	"")	},
   { 0,			Ukn	ITR(1, "?",	"")	},
   { 0,			Ukn	ITR(1, "?",	"")	},
   { 0,			Ukn	ITR(1, "?",	"")	},
   { 0,			Ukn	ITR(1, "?",	"")	}
};

/* ------------------------------------------------------------------ */

#ifdef IBCS_TRACE
static IBCS_func LNX_func_0x00[] = {
   { ibcs_trace_set,	1	ITR(0, "trace",		"d")	}, /*  0 */
   { ibcs_trace_func,	3	ITR(0, "trace",		"ddd")	}, /*  1 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  2 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  3 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  4 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  5 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  6 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /*  7 */
};
static IBCS_func *iBCS_group_LNX[] = {
	LNX_func_0x00
};
#endif

/* ------------------------------------------------------------------ */

static IBCS_func WYSETCP_func_0x00[] = {
   { ibcs_select,	Spl	ITR(0, "select",	"dxxxx")},/*  0 */
   { wv386_socket,	Spl	ITR(0, "socket",	"ddd")	}, /*  1 */
   { wv386_connect,	Spl	ITR(0, "connect",	"dxd")	}, /*  2 */
   { wv386_accept,	Spl	ITR(0, "accept",	"dxx")	}, /*  3 */
   { wv386_send,	Spl	ITR(0, "send",		"dxdd")}, /*  4 */
   { wv386_recv,	Spl	ITR(0, "recv",		"dxdd")}, /*  5 */
   { wv386_bind,	Spl	ITR(0, "bind",		"dxd")	}, /*  6 */
   { wv386_setsockopt,	Spl	ITR(0, "setsockopt",	"")	}  /*  7 */
};
static IBCS_func WYSETCP_func_0x08[] = {
   { wv386_listen,	Spl	ITR(0, "listen",	"")	}, /*  8 */
   { 0,			3	ITR(1, "recvmsg",	"dxd")	}, /*  9 */
   { 0,			3	ITR(1, "sendmsg",	"dxd")	}, /* 10 */
   { wv386_getsockopt,	Spl	ITR(0, "getsockopt",	"")	}, /* 11 */
   { wv386_recvfrom,	Spl	ITR(0, "recvfrom",	"dxddxd")},/* 12 */
   { wv386_sendto,	Spl	ITR(0, "sendto",	"dxddxd")},/* 13 */
   { wv386_shutdown,	Spl	ITR(0, "shutdown",	"dd")	}, /* 14 */
   { wv386_socketpair,	Spl	ITR(0, "socketpair",	"dddx")}  /* 15 */
};
static IBCS_func WYSETCP_func_0x10[] = {
   { 0,			Ukn	ITR(1, "trace",		"")	}, /* 16 */
   { wv386_getpeername,	Spl	ITR(0, "getpeername",	"dxx")	}, /* 17 */
   { wv386_getsockname,	Spl	ITR(0, "getsockname",	"")	}, /* 18 */
   { wv386_wait3,	1	ITR(0, "wait3",		"x")	}, /* 19 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 20 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 21 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 22 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /* 23 */
};
static IBCS_func *iBCS_group_WYSETCP[] = {
	WYSETCP_func_0x00,
	WYSETCP_func_0x08,
	WYSETCP_func_0x10
};

/* ------------------------------------------------------------------ */

static IBCS_func WYSENFS_func_0x00[] = {
   { 0,			Ukn	ITR(1, "nfs_svc",	"")	}, /*  0 */
   { 0,			Ukn	ITR(1, "aync_daemon",	"")	}, /*  1 */
   { 0,			Ukn	ITR(1, "nfs_getfh",	"")	}, /*  2 */
   { 0,			Ukn	ITR(1, "nfsmount",	"")	}, /*  3 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  4 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  5 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  6 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /*  7 */
};
static IBCS_func *iBCS_group_WYSENFS[] = {
	WYSENFS_func_0x00
};

/* ------------------------------------------------------------------ */

static IBCS_func XNX_func_0x00[] = {
   { 0,			Ukn	ITR(1, "syscall",	"")	}, /*  0 */
   { xnx_locking,	3	ITR(1, "locking",	"ddd")	}, /*  1 */
   { xnx_creatsem,	2	ITR(1, "creatsem",	"sd")	}, /*  2 */
   { xnx_opensem,	1	ITR(1, "opensem",	"s")	}, /*  3 */
   { xnx_sigsem,	1	ITR(1, "sigsem",	"d")	}, /*  4 */
   { xnx_waitsem,	1	ITR(1, "waitsem",	"d")	}, /*  5 */
   { xnx_nbwaitsem,	1	ITR(1, "nbwaitsem",	"d")	}, /*  6 */
   { xnx_rdchk,		1	ITR(0, "rdchk",		"d")	}  /*  7 */
};
static IBCS_func XNX_func_0x08[] = {
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  8 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*  9 */
   { SC(ftruncate),	2	ITR(0, "chsize",	"dd")	}, /* 10 */
   { xnx_ftime,		1	ITR(0, "ftime",		"x")	}, /* 11 */
   { xnx_nap,		1	ITR(0, "nap",		"d")	}, /* 12 */
   { xnx_sdget,		4	ITR(1, "sdget",		"sddd") }, /* 13 */
   { xnx_sdfree,	1	ITR(1, "sdfree",	"x")	}, /* 14 */
   { xnx_sdenter,	2	ITR(1, "sdenter",	"xd")	}  /* 15 */
};
static IBCS_func XNX_func_0x10[] = {
   { xnx_sdleave,	1	ITR(1, "sdleave",	"x")	}, /* 16 */
   { xnx_sdgetv,	1	ITR(1, "sdgetv",	"x")	}, /* 17 */
   { xnx_sdwaitv,	2	ITR(1, "sdwaitv",	"xd")	}, /* 18 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 19 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 20 */
   { 0,			1	ITR(0, "unknown-sco",	"d")	}, /* 21 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 22 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /* 23 */
};
static IBCS_func XNX_func_0x20[] = {
   { xnx_proctl,	3	ITR(0, "proctl",	"ddx")	}, /* 32 */
   { xnx_execseg,	2	ITR(1, "execseg",	"xd")	}, /* 33 */
   { xnx_unexecseg,	1	ITR(1, "unexecseg",	"x")	}, /* 34 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 35 */
   { ibcs_select,	Spl	ITR(0, "select",	"dxxxx")}, /* 36 */
   { xnx_eaccess,	2	ITR(0, "eaccess",	"so")	}, /* 37 */
   { xnx_paccess,	5	ITR(1, "paccess",	"dddds")},/* 38 */
   { xnx_sigaction,	3	ITR(1, "sigaction",	"dxx")	}  /* 39 */
};
static IBCS_func XNX_func_0x28[] = {
   { xnx_sigprocmask,	3	ITR(1, "sigprocmask",	"dxx")	}, /* 40 */
   { xnx_sigpending,	1	ITR(1, "sigpending",	"x")	}, /* 41 */
   { xnx_sigsuspend,	1	ITR(1, "sigsuspend",	"x")	}, /* 42 */
   { SC(getgroups),	-2	ITR(0, "getgroups",	"dx")	}, /* 43 */
   { SC(setgroups),	-2	ITR(0, "setgroups",	"dx")	}, /* 44 */
   { ibcs_sysconf,	1	ITR(0, "sysconf",	"d")	}, /* 45 */
   { xnx_pathconf,	2	ITR(0, "pathconf",	"sd")	}, /* 46 */
   { xnx_fpathconf,	2	ITR(0, "fpathconf",	"dd")	}  /* 47 */
};
static IBCS_func XNX_func_0x30[] = {
   { SC(rename),	-2	ITR(0, "rename",	"ss")	}, /* 48 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 49 */
   { sco_utsname,	1	ITR(0, "sco_utsname",	"x")	}, /* 50 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 51 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 52 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 53 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /* 54 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /* 55 */
};
static IBCS_func *iBCS_group_XNX[] = {
	XNX_func_0x00,
	XNX_func_0x08,
	XNX_func_0x10,
	Unused,
	XNX_func_0x20,
	XNX_func_0x28,
	XNX_func_0x30
};

static IBCS_func ISC_sysisc_func_0x00[] = {
   { 0,			Ukn	ITR(1, "isc_syisc0",	"")	}, /* 00 */
   { isc_setostype,	1	ITR(0, "isc_setostype",	"d")	}, /* 01 */
   { SC(rename),	-2	ITR(0, "isc_rename",	"ss")	}, /* 02 */
   { abi_sigaction,	3	ITR(0, "isc_sigaction",	"dxx")	}, /* 03 */
   { abi_sigprocmask,	3	ITR(0, "isc_sicprocmask","dxx")	}, /* 04 */
   { 0,			1	ITR(0, "isc_sigpending","x")	}, /* 05 */
   { SC(getgroups),	-2	ITR(0, "isc_getgroups",	"dp")	}, /* 06 */
   { SC(setgroups),	-2	ITR(1, "isc_setgroups",	"dp")	}, /* 07 */
};
static IBCS_func ISC_sysisc_func_0x08[] = {
   { 0,			Ukn	ITR(1, "pathconf",	"")	}, /* 08 */
   { 0,			Ukn	ITR(1, "fpathconf",	"")	}, /* 09 */
   { ibcs_sysconf,	1	ITR(0, "sysconf",	"d")	}, /* 10 */
   { SC(waitpid),	-3	ITR(0, "isc_waitpid",	"dxx")	}, /* 11 */
   { SC(setsid),	-ZERO	ITR(0, "isc_setsid",	"")	}, /* 12 */
   { SC(setpgid),	-2	ITR(1, "isc_setpgid",	"dd")	}, /* 13 */
   { 0,			Ukn	ITR(1, "isc_adduser",	"")	}, /* 14 */
   { 0,			Ukn	ITR(1, "isc_setuser",	"")	}, /* 15 */
};
static IBCS_func ISC_sysisc_func_0x10[] = {
   { 0,			Ukn	ITR(1, "isc_sysisc16",	"")	}, /* 16 */
   { abi_sigsuspend,	1	ITR(0, "isc_sigsuspend","x")	}, /* 17 */
   { SC(symlink),	-2	ITR(0, "isc_symlink",	"ss")	}, /* 18 */
   { SC(readlink),	-3	ITR(0, "isc_readlink",	"spd")	}, /* 19 */
   { 0,			Ukn	ITR(1, "isc_getmajor",	"")	}, /* 20 */
   { 0,			Ukn	ITR(1, "sysisc21",	"")	}, /* 21 */
   { 0,			Ukn	ITR(1, "sysisc22",	"")	}, /* 22 */
   { 0,			Ukn	ITR(1, "sysisc23",	"")	}, /* 23 */
};

static IBCS_func *iBCS_group_ISC_sysisc[] = {
	ISC_sysisc_func_0x00,
	ISC_sysisc_func_0x08,
	ISC_sysisc_func_0x10,
};
/* ------------------------------------------------------------------ */

static IBCS_func iBCS_func_0x00[] = {
   { ibcs_syscall,	Fast	ITR(0, "syscall",	"")	}, /*    0 */
#ifndef CONFIG_BINFMT_IBCS
   { ibcs_exit,		1	ITR(0, "exit",		"d")	}, /*    1 */
#else
   { SC(exit),		-1	ITR(0, "exit",		"d")	}, /*    1 */
#endif
   { ibcs_fork,		Spl	ITR(0, "fork",		"")	}, /*    2 */
   { ibcs_read,		3	ITR(0, "read",		"dpd")	}, /*    3 */
   { SC(write),		-3	ITR(0, "write",		"dpd")	}, /*    4 */
   { ibcs_open,		3	ITR(0, "open",		"soo")	}, /*    5 */
   { SC(close),		-1	ITR(0, "close",		"d")	}, /*    6 */
   { ibcs_wait,		Spl	ITR(0, "wait",		"xxx")	}  /*    7 */
};
static IBCS_func iBCS_func_0x08[] = {
   { SC(creat),		-2	ITR(0, "creat",		"so")	}, /*    8 */
   { SC(link),		-2	ITR(0, "link",		"ss")	}, /*    9 */
   { SC(unlink),	-1	ITR(0, "unlink",	"s")	}, /*   10 */
   { ibcs_exec,		Spl	ITR(0, "exec",		"sxx")	}, /*   11 */
   { SC(chdir),		-1	ITR(0, "chdir",		"s")	}, /*   12 */
   { ibcs_time,		0	ITR(0, "time",		"")	}, /*   13 */
   { SC(mknod),		-3	ITR(0, "mknod",		"soo")	}, /*   14 */
   { SC(chmod),		-2	ITR(0, "chmod",		"so")	}  /*   15 */
};
static IBCS_func iBCS_func_0x10[] = {
   { SC(chown),		-3	ITR(0, "chown",		"sdd")	}, /*   16 */
   { SC(brk),		-1	ITR(0, "brk/break",	"x")	}, /*   17 */
   { ibcs_stat,		2	ITR(0, "stat",		"sp")	}, /*   18 */
   { SC(lseek),		-3	ITR(0, "seek/lseek",	"ddd")	}, /*   19 */
   { ibcs_getpid,	Spl	ITR(0, "getpid",	"")	}, /*   20 */
   { 0,			Ukn	ITR(1, "mount",		"")	}, /*   21 */
   { SC(umount),	-1	ITR(0, "umount",	"s")	}, /*   22 */
   { SC(setuid),	-1	ITR(0, "setuid",	"d")	}  /*   23 */
};
static IBCS_func iBCS_func_0x18[] = {
   { ibcs_getuid,	Spl	ITR(0, "getuid",	"")	}, /*   24 */
   { SC(stime),		-1	ITR(0, "stime",		"d")	}, /*   25 */
   { SC(ptrace),	-4	ITR(0, "ptrace",	"xxxx")}, /*   26 */
   { SC(alarm),		-1	ITR(0, "alarm",		"d")	}, /*   27 */
   { ibcs_fstat,	2	ITR(0, "fstat",		"dp")	}, /*   28 */
   { SC(pause),		-ZERO	ITR(0, "pause",		"")	}, /*   29 */
   { SC(utime),		-2	ITR(0, "utime",		"xx")	}, /*   30 */
   { 0,			Ukn	ITR(0, "stty",		"")	}  /*   31 */
};
static IBCS_func iBCS_func_0x20[] = {
   { 0,			Ukn	ITR(1, "gtty",		"")	}, /*   32 */
   { SC(access),	-2	ITR(0, "access",	"so")	}, /*   33 */
   { SC(nice),		-1	ITR(0, "nice",		"d")	}, /*   34 */
   { ibcs_statfs,	2	ITR(0, "statfs",	"sp")	}, /*   35 */
   { SC(sync),		-ZERO	ITR(0, "sync",		"")	}, /*   36 */
   { ibcs_kill,		2	ITR(0, "kill",		"dd")	}, /*   37 */
   { ibcs_fstatfs,	2	ITR(0, "fstatfs",	"dp")	}, /*   38 */
   { ibcs_procids,	Spl	ITR(0, "ibcs_procids",	"d")	}  /*   39 */
};
static IBCS_func iBCS_func_0x28[] = {
   { iBCS_group_XNX,	Class	ITR(0, "cxenix",	"")	}, /*   40 */
   { SC(dup),		-1	ITR(0, "dup",		"d")	}, /*   41 */
   { ibcs_pipe,		Spl	ITR(0, "pipe",		"")	}, /*   42 */
   { SC(times),		-1	ITR(0, "times",		"p")	}, /*   43 */
   { SC(profil),	-4	ITR(0, "prof",		"xxxx")}, /*   44 */
   { 0,			Ukn	ITR(1, "lock/plock",	"")	}, /*   45 */
   { SC(setgid),	-1	ITR(0, "setgid",	"d")	}, /*   46 */
   { ibcs_getgid,	Spl	ITR(0, "getgid",	"")	}  /*   47 */
};
static IBCS_func iBCS_func_0x30[] = {
   { ibcs_sigfunc,	Fast	ITR(0, "signal",	"xxx")	}, /*   48 */
   { ibcs_msgsys,	Spl	ITR(0, "msgsys",	"dxddd")}, /*   49 */
   { ibcs_sysi86,	Spl	ITR(0, "sysi86/sys3b",	"d")	}, /*   50 */
   { SC(acct),		-1	ITR(0, "acct/sysacct",	"x")	}, /*   51 */
   { ibcs_shmsys,	Fast	ITR(0, "shmsys",	"ddxo")}, /*   52 */
   { ibcs_semsys,	Spl	ITR(0, "semsys",	"dddx")}, /*   53 */
   { ibcs_ioctl,	3	ITR(0, "ioctl",		"dxx")	}, /*   54 */
   { 0,			3	ITR(0, "uadmin",	"xxx")	}  /*   55 */
};
static IBCS_func iBCS_func_0x38[] = {
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   56 */
   { v7_utsname,	1	ITR(0, "utsys",		"x")	}, /*   57 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   58 */
   { ibcs_execv,	Spl	ITR(0, "execv",		"spp")	}, /*   59 */
   { SC(umask),	-1	ITR(0, "umask",		"o")	}, /*   60 */
   { SC(chroot),	-1	ITR(0, "chroot",	"s")	}, /*   61 */
   { ibcs_fcntl,	Spl	ITR(0, "fcntl",		"ddx")	}, /*   62 */
   { ibcs_ulimit,	2	ITR(0, "ulimit",	"xx")	}  /*   63 */
};
static IBCS_func ISCR4_func_0x38[] = {
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   56 */
   { v7_utsname,	1	ITR(0, "utsys",		"x")	}, /*   57 */
   { SC(fsync),		-1	ITR(1, "fsync",		"d")	}, /*   58 */
   { ibcs_execv,	Spl	ITR(0, "execv",		"spp")	}, /*   59 */
   { SC(umask),	-1	ITR(0, "umask",		"o")	}, /*   60 */
   { SC(chroot),	-1	ITR(0, "chroot",	"s")	}, /*   61 */
   { ibcs_fcntl,	Spl	ITR(0, "fcntl",		"ddx")	}, /*   62 */
   { ibcs_ulimit,	2	ITR(0, "ulimit",	"xx")	}  /*   63 */
};
static IBCS_func iBCS_func_0x40[] = {
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   64 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   65 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   66 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   67 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   68 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   69 */
   { 0,			Ukn	ITR(1, "advfs",		"")	}, /*   70 */
   { 0,			Ukn	ITR(1, "unadvfs",	"")	}  /*   71 */
};
static IBCS_func iBCS_func_0x48[] = {
   { 0,			Ukn	ITR(1, "rmount",	"")	}, /*   72 */
   { 0,			Ukn	ITR(1, "rumount",	"")	}, /*   73 */
   { 0,			Ukn	ITR(1, "rfstart",	"")	}, /*   74 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   75 */
   { 0,			Ukn	ITR(1, "rdebug",	"")	}, /*   76 */
   { 0,			Ukn	ITR(1, "rfstop",	"")	}, /*   77 */
   { 0,			Ukn	ITR(1, "rfsys",		"")	}, /*   78 */
   { SC(rmdir),	-1	ITR(0, "rmdir",		"s")	}  /*   79 */
};
static IBCS_func iBCS_func_0x50[] = {
   { SC(mkdir),	-2	ITR(0, "mkdir",		"so")	}, /*   80 */
   { ibcs_getdents,	3	ITR(0, "getdents",	"dxd")	}, /*   81 */
   { 0,			Ukn	ITR(1, "libattach",	"")	}, /*   82 */
   { 0,			Ukn	ITR(1, "libdetach",	"")	}, /*   83 */
#ifndef __NR_sysfs
   { ibcs_sysfs,	Spl	ITR(0, "sysfs",		"dxx")	}, /*   84 */
#else
   { SC(sysfs),		-3	ITR(0, "sysfs",		"dxx")	}, /*	84 */
#endif
   { ibcs_getmsg,	4	ITR(0, "getmsg",	"dxxx")	}, /*   85 */
   { ibcs_putmsg,	4	ITR(0, "putmsg",	"dxxd")	}, /*   86 */
   { ibcs_poll,		3	ITR(0, "poll",		"xdd")	}  /*   87 */
};
static IBCS_func iBCS_func_0x58[] = {
   { ibcs_lstat,	2	ITR(0, "lstat",		"sp")	}, /*   88 */
   { SC(symlink),	-2	ITR(0, "symlink",	"ss")	}, /*   89 */
   { SC(readlink),	-3	ITR(0, "readlink",	"spd")	}, /*   90 */
   { SC(setgroups),	-2	ITR(0, "setgroups",	"dp")	}, /*   91 */
   { SC(getgroups),	-2	ITR(0, "getgroups",	"dp")	}, /*   92 */
   { 0,			3	ITR(1, "fchmod",	"do")	}, /*   93 */
   { 0,			3	ITR(1, "fchown",	"dxx")	}, /*   94 */
   { abi_sigprocmask,	3	ITR(0, "sigprocmask",	"dxx")	}  /*   95 */
};
static IBCS_func SCOSVR3_func_0x58[] = {
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   88 */
   { sw_security,	6	ITR(0, "security",	"dxxxxx")}, /*   89 */
   { SC(symlink),	-2	ITR(0, "symlink",	"ss")	}, /*   90 */
   { ibcs_lstat,	2	ITR(0, "lstat",		"sp")	}, /*   91 */
   { SC(readlink),	-3	ITR(0, "readlink",	"spd")	}, /*   92 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   93 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   94 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /*   95 */
};
static IBCS_func ISCR4_func_0x58[] = {
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   88 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   89 */
   { SC(symlink),	-2	ITR(0, "symlink",	"ss")	}, /*   90 */
   { ibcs_lstat,	2	ITR(0, "lstat",		"sp")	}, /*   91 */
   { SC(readlink),	-3	ITR(0, "readlink",	"spd")	}, /*   92 */
   { 0,			Ukn	ITR(1,	 "?",		"")	}, /*   93 */
   { 0,			Ukn	ITR(1,	 "?",		"")	}, /*   94 */
   { 0,			Ukn	ITR(1,	 "?",		"")	}  /*   95 */
};
static IBCS_func iBCS_func_0x60[] = {
   { abi_sigsuspend,	Spl	ITR(0, "sigsuspend",	"x")	}, /*   96 */
   { 0,			2	ITR(1, "sigaltstack",	"xx")	}, /*   97 */
   { abi_sigaction,	3	ITR(0, "sigaction",	"dxx")	}, /*   98 */
   { 0,			1	ITR(1, "sigpending",	"x")	}, /*   99 */
   { 0,			Ukn	ITR(1, "context",	"")	}, /*   100 */
   { 0,			Ukn	ITR(1, "evsys",		"")	}, /*   101 */
   { 0,			Ukn	ITR(1, "evtrapret",	"")	}, /*   102 */
   { 0,			Ukn	ITR(1, "statvfs",	"")	}  /*   103 */
};
static IBCS_func iBCS_func_0x68[] = {
   { 0,			Ukn	ITR(1, "fstatvfs",	"")	}, /*   104 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   105 */
   { 0,			Ukn	ITR(1, "nfssys",	"")	}, /*   106 */
   { 0,			Ukn	ITR(1, "waitsys",	"")	}, /*   107 */
   { 0,			Ukn	ITR(1, "sigsendsys",	"")	}, /*   108 */
   { ibcs_hrtsys,	Spl	ITR(0, "hrtsys",	"xxx")	}, /*   109 */
   { 0,			Ukn	ITR(1, "acancel",	"")	}, /*   110 */
   { 0,			Ukn	ITR(1, "async",		"")	}  /*   111 */
};
static IBCS_func ISCR4_func_0x68[] = {
   { 0,			Ukn	ITR(1, "fstatvfs",	"")	}, /*   104 */
   { iBCS_group_ISC_sysisc,ISC  ITR(1, "sysisc",	"")	}, /*   105 */
   { 0,			Ukn	ITR(1, "nfssys",	"")	}, /*   106 */
   { 0,			Ukn	ITR(1, "waitsys",	"")	}, /*   107 */
   { 0,			Ukn	ITR(1, "sigsendsys",	"")	}, /*   108 */
   { ibcs_hrtsys,	Spl	ITR(0, "hrtsys",	"xxx")	}, /*   109 */
   { 0,			Ukn	ITR(1, "acancel",	"")	}, /*   110 */
   { 0,			Ukn	ITR(1, "async",		"")	}  /*   111 */
};
static IBCS_func iBCS_func_0x70[] = {
   { 0,			Ukn	ITR(1, "priocntlsys",	"")	}, /*   112 */
   { 0,			Ukn	ITR(1, "pathconf",	"")	}, /*   113 */
   { 0,			Ukn	ITR(1, "mincore",	"")	}, /*   114 */
   { ibcs_mmap,		6	ITR(0, "mmap",		"xxxxdx") },/*   115 */
   { SC(mprotect),	-3	ITR(0, "mprotect",	"xdx")  },/*   116 */
   { SC(munmap),	-2	ITR(0, "munmap",	"xd")   },/*   117 */
   { 0,			Ukn	ITR(1, "fpathconf",	"")	}, /*   118 */
   { 0,			Ukn	ITR(1, "vfork",		"")	}  /*   119 */
};
static IBCS_func iBCS_func_0x78[] = {
   { 0,			Ukn	ITR(1, "fchdir",	"")	}, /*   120 */
   { 0,			Ukn	ITR(1, "readv",		"")	}, /*   121 */
   { 0,			Ukn	ITR(1, "writev",	"")	}, /*   122 */
   { ibcs_xstat,	3	ITR(0, "xstat",		"dsx")	}, /*   123 */
   { ibcs_lxstat,     	3	ITR(0, "lxstat",	"dsx")	}, /*   124 */
   { ibcs_fxstat,	3	ITR(0, "fxstat",	"ddx")	}, /*   125 */
   { ibcs_xmknod,	4	ITR(0, "xmknod",	"dsox")}, /*   126 */
   { 0,			Ukn	ITR(1, "clocal",	"")	}  /*   127 */
};
static IBCS_func iBCS_func_0x80[] = {
   { 0,			Ukn	ITR(1, "setrlimit",	"")	}, /*   128 */
   { 0,			Ukn	ITR(1, "getrlimit",	"")	}, /*   129 */
   { 0,			Ukn	ITR(1, "lchown",	"")	}, /*   130 */
   { 0,			Ukn	ITR(1, "memcntl",	"")	}, /*   131 */
   { 0,			Ukn	ITR(1, "getpmsg",	"")	}, /*   132 */
   { 0,			Ukn	ITR(1, "putpmsg",	"")	}, /*   133 */
   { SC(rename),	-2	ITR(1, "rename",	"ss")	}, /*   134 */
   { abi_utsname,	1	ITR(1, "uname",		"x")	}  /*   135 */
};
static IBCS_func WYSEV386_func_0x80[] = {
   { ibcs_lstat,	2	ITR(0, "lstat",		"sp")	}, /*   128 */
   { SC(readlink),	-3	ITR(0, "readlink",	"spd")	}, /*   129 */
   { SC(symlink),	-2	ITR(0, "symlink",	"ss")	}, /*   130 */
   { iBCS_group_WYSETCP,Class	ITR(0, "?",		"")	}, /*   131 */
   { iBCS_group_WYSENFS,Class	ITR(0, "?",		"")	}, /*   132 */
   { wv386_gethostname,	2	ITR(0, "gethostname",	"xd")	}, /*   133 */
   { SC(sethostname),	-2	ITR(0, "sethostname",	"sd")	}, /*   134 */
   { wv386_getdomainname,2	ITR(0, "getdomainname","xd")	}  /*   135 */
};
static IBCS_func iBCS_func_0x88[] = {
   { 0,			Ukn	ITR(1, "setegid",	"")	}, /*   136 */
   { 0,			Ukn	ITR(1, "sysconfig",	"")	}, /*   137 */
   { 0,			Ukn	ITR(1, "adjtime",	"")	}, /*   138 */
   { 0,			Ukn	ITR(1, "systeminfo",	"")	}, /*   139 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   140 */
   { 0,			Ukn	ITR(1, "seteuid",	"")	}, /*   141 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   142 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /*   143 */
};
static IBCS_func WYSEV386_func_0x88[] = {
   { SC(setdomainname),	-2	ITR(0, "setdomainname","sd")	}, /*   136 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   137 */
   { SC(setreuid),	-2	ITR(0, "setreuid",	"dd")	}, /*   138 */
   { SC(setregid),	-2	ITR(0, "setregid",	"dd")	}, /*   139 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   140 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   141 */
   { 0,			Ukn	ITR(1, "?",		"")	}, /*   142 */
   { 0,			Ukn	ITR(1, "?",		"")	}  /*   143 */
};
static IBCS_func iBCS_func_0xf8[] = {
   { 0,			Ukn	ITR(1, "?",		"")	},
   { 0,			Ukn	ITR(1, "?",		"")	},
   { 0,			Ukn	ITR(1, "?",		"")	},
   { 0,			Ukn	ITR(1, "?",		"")	},
   { 0,			Ukn	ITR(1, "?",		"")	},
   { 0,			Ukn	ITR(1, "?",		"")	},
   { iBCS_group_WYSETCP,Class	ITR(1, "?",		"")	},
#ifdef IBCS_TRACE
   { iBCS_group_LNX,	Class	ITR(0, "?",		"")	}
#else
   { 0,			Ukn	ITR(1, "?",		"")	}
#endif
};
static IBCS_func *iBCS_group_SVR4[] = {
	iBCS_func_0x00,
	iBCS_func_0x08,
	iBCS_func_0x10,
	iBCS_func_0x18,
	iBCS_func_0x20,
	iBCS_func_0x28,
	iBCS_func_0x30,
	iBCS_func_0x38,
	iBCS_func_0x40,
	iBCS_func_0x48,
	iBCS_func_0x50,
	iBCS_func_0x58,
	iBCS_func_0x60,
	iBCS_func_0x68,
	iBCS_func_0x70,
	iBCS_func_0x78,
	iBCS_func_0x80,
	iBCS_func_0x88,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	iBCS_func_0xf8
};
static IBCS_func *iBCS_group_SCOSVR3[] = {
	iBCS_func_0x00,
	iBCS_func_0x08,
	iBCS_func_0x10,
	iBCS_func_0x18,
	iBCS_func_0x20,
	iBCS_func_0x28,
	iBCS_func_0x30,
	iBCS_func_0x38,
	iBCS_func_0x40,
	iBCS_func_0x48,
	iBCS_func_0x50,
	SCOSVR3_func_0x58,
	Unused,
	Unused,
	Unused,
	Unused, /* clocal() is here but who cares? */
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	iBCS_func_0xf8
};
static IBCS_func *iBCS_group_WYSEV386[] = {
	iBCS_func_0x00,
	iBCS_func_0x08,
	iBCS_func_0x10,
	iBCS_func_0x18,
	iBCS_func_0x20,
	iBCS_func_0x28,
	iBCS_func_0x30,
	iBCS_func_0x38,
	iBCS_func_0x40,
	iBCS_func_0x48,
	iBCS_func_0x50,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	WYSEV386_func_0x80,
	WYSEV386_func_0x88,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	iBCS_func_0xf8
};

static IBCS_func *iBCS_group_ISCR4[] = {
	iBCS_func_0x00,
	iBCS_func_0x08,
	iBCS_func_0x10,
	iBCS_func_0x18,
	iBCS_func_0x20,
	iBCS_func_0x28,
	iBCS_func_0x30,
	ISCR4_func_0x38,
	iBCS_func_0x40,
	iBCS_func_0x48,
	iBCS_func_0x50,
	ISCR4_func_0x58,
	Unused,
	ISCR4_func_0x68,
	iBCS_func_0x70,
	iBCS_func_0x78,
	iBCS_func_0x80,
	iBCS_func_0x88,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	Unused,
	iBCS_func_0xf8
};

/* The following sequence should match the defined values in the
 * header linux/include/linux/personality.h
 */
static IBCS_func **iBCS_personality_map[] = {
	iBCS_group_SVR4,	/* This (Linux) should never be used? */
	iBCS_group_SVR4,	/* SVR4 (base iBCS) */
	iBCS_group_SVR4,	/* Base SVR3 (no extensions) is a subset
				 * of SVR4.
				 */
	iBCS_group_SCOSVR3,	/* SVR3 with SCO extensions. */
	iBCS_group_WYSEV386,	/* SVR3 with Wyse extensions. */
	iBCS_group_ISCR4	/* lets try ISC 4.0 with posix */
};
