
FOREIGN MODULE msXDW;

(*
 *  Simple X Display Window Library for Modula-2*
 *
 *  all output goes to the X display window
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Stefan Haenssgen,
 *        Ernst A. Heinz, and Paul Lukowicz
 *
 *  Last change: 16.09.1993
 *)

FROM SYSTEM IMPORT
  ADDRESS;

TYPE singleColor = RECORD
                    red, green, blue : SHORTCARD;
		   END; 				    
     colorPtr = POINTER TO ARRAY[0..32767] OF singleColor;

VAR  mouseX, mouseY, mouseButton : INTEGER;
     backgrounds, foregrounds	 : ADDRESS;
     colors			 : ADDRESS;
     height, width		 : INTEGER;
     maxcolors			 : INTEGER;
     pixelbuffer		 : ADDRESS;

PROCEDURE ClearDW;
  (* clear the display window *)
PROCEDURE CloseDW;
  (* close the display window *)
PROCEDURE Circle( x, y, r, color: INTEGER; filled: BOOLEAN );
  (* draw a probably filled circle in the given color *)
PROCEDURE Draw( x, y, color: INTEGER );
  (* draw a dot in the given color *)
PROCEDURE Ellipse( x, y, r1, r2, color: INTEGER; filled: BOOLEAN );
  (* draw a probably filled ellipse in the given color *)
PROCEDURE FDraw( x, y, color: INTEGER );
  (* draw a dot in the given color (does not update the display window) *)
PROCEDURE FDrawBW( x, y, color: INTEGER );
  (* draw a dot in black or white (does not update the display window) *)
PROCEDURE FDrawMono( x, y, color: INTEGER );
  (* for monochrome monitors (does not update the display window) *)
PROCEDURE Line( x1, y1, x2, y2, color: INTEGER );
  (* draw a line in the given color *)
PROCEDURE Mouse( VAR x, y, button: INTEGER );
  (* return the mouse position and its button status
     if the mouse is not inside the display window then x = y = -1
     button = 1*left + 2*middle + 4*right (if any button pressed)  *)
PROCEDURE OpenDW( x, y, width, height, numcolors: INTEGER;
		  colors: colorPtr; wtitle: ARRAY OF CHAR );
  (* open the display window (default colors are used if "colors=NIL") *)
PROCEDURE Rectangle( x, y, width, height, color: INTEGER; filled: BOOLEAN );
  (* draw a probably filled rectangle in the given color *)
PROCEDURE SetDWFont( fontname: ARRAY OF CHAR );
  (* set font used for text output in the display window *)
PROCEDURE Text( x, y, color: INTEGER; str: ARRAY OF CHAR );
  (* print a string in the given color *)
PROCEDURE UpdateDW;
  (* update the display window *)
PROCEDURE WaitClick;
  (* wait until any mouse button is pressed inside the display window*)

(* the same as above but with longer and more descriptive names ... *)

PROCEDURE ClearDisplayWindow;
PROCEDURE CloseDisplayWindow;
PROCEDURE DrawCircle( x, y, r, color: INTEGER; filled: BOOLEAN );
PROCEDURE DrawEllipse( x, y, r1, r2, color: INTEGER; filled: BOOLEAN );
PROCEDURE DrawLine( x1, y1, x2, y2, color: INTEGER );
PROCEDURE DrawPixel( x, y, color: INTEGER );
PROCEDURE DrawRectangle( x, y, width, height, color: INTEGER; filled: BOOLEAN );
PROCEDURE DrawString( x, y, color: INTEGER; str: ARRAY OF CHAR );
PROCEDURE FastDrawPixel( x, y, color: INTEGER );
PROCEDURE FastDrawBWPixel( x, y, color: INTEGER );
PROCEDURE FastDrawMonoPixel( x, y, color: INTEGER );
PROCEDURE GetMouseData( VAR x, y, button: INTEGER );
PROCEDURE OpenDisplayWindow( x, y, width, height, numcolors: INTEGER;
			     colors: colorPtr; wtitle: ARRAY OF CHAR );
PROCEDURE SetDisplayWindowFont( fontname: ARRAY OF CHAR );
PROCEDURE UpdateDisplayWindow;
PROCEDURE WaitForMouseClick;

END msXDW.








