From daemon Thu May  6 21:27 PDT 1993
Received: from skink.cis.ohio-state.edu by dns1.eecs.wsu.edu (16.6/5.910402)
	id AA29552; Thu, 6 May 93 21:27:04 -0700
Received: by skink.cis.ohio-state.edu (5.61-kk/5.911008)
	id AA18165; Fri, 7 May 93 00:27:01 -0400
Date: Fri, 7 May 93 00:27:01 -0400
From: Krishna Balasubramanian <balasub@cis.ohio-state.edu>
Message-Id: <9305070427.AA18165@skink.cis.ohio-state.edu>
To: obz@kodak.com, hlu@eecs.wsu.edu
Subject: Re:  SYSV IPC
Status: OR


>>Linus said he'd include it sooner or later ...
>>Actually he said soon after 1.0 but then 1.0 has
>>been a longer in coming than I thought.
>>
>>I haven't spoken to HJ about the libraries ..
>>I thought that would follow when Linus
>>put it in. ... perhaps I should do this too.
>>krishna

>Ok. I don't mind having to make the kernel patches - they are independent
>of the application (from a linking perspective). The only fly in the ointment
>is the missing system calls in the c library. Those require a bunch of
>changes to the X sources so they link with some libshm.a or so. It would be
>better to have those right in libc. As a matter of fact, hlu is getting
>ready to release libc 4.4. Perhaps it would be a good idea to send him
>the libipc.c file of yours, if you don't think things will be changing
>very much. That would make it much easier for me to incorporate shm into
>the X sources.

>Orest Zborowski (Zorst)
>obz@Kodak.COM

ipcdelta constists of 
1) kernel source (4 files)
2) kernel patches
3) kernel include files (4 files)
4) sys include files (4 files)
5) libipc.c .... simple wrappers for sys_ipc

libipc.c should not change unless either of you sees
something manifestly ugly in it.
The include files might have some constants refined
later...but nothing major.

So HJ do you think its possible to include libipc.c
into libc? I'll send you the remaining files if
you think its possible.

Since X is used very widely it may not be a good idea
to make it dependent on these patches before Linus puts
them into the standard kernel ... much as I'd like 
to see them make it into the main stream ...

krishna

/*
 *  linux/lib/ipc.c
 *
 *  (C) 1992  Krishna Balasubramanian
 */

#define KERNEL
#include <linux/unistd.h>
#include <sys/shm.h>
#include <sys/msg.h>
#include <sys/sem.h>
#include <sys/stat.h>
#define NONE 0

/* wrapper for ipc syscalls */
_syscall5(int,ipc,int,call,int,first,int,second,int,third,void *,ptr)

/* SEM SYSCALLS */
int semget (key_t key, int nsems, int semflg)
{
    return ipc (SEMGET, key, nsems, semflg, NULL);
}
int semop (int semid, struct sembuf *sops, unsigned nsops)
{
    return ipc (SEMOP, semid, (int) nsops, NONE, sops);
}

int semctl (int semid, int semnum, int cmd, union semun arg)
{
    return ipc (SEMCTL, semid, semnum, cmd, &arg);
}


/* MSG SYSCALLS */
int msgctl (int msqid, int cmd, struct msqid_ds *buf)
{
    return ipc (MSGCTL, msqid, cmd, NONE, buf);
}

int msgget (key_t key, int msgflg)
{
    return ipc (MSGGET, key, msgflg, NONE, NULL);
}

int msgsnd (int msqid, struct msgbuf *msgp, int msgsz, int msgflg)
{
    return ipc (MSGSND, msqid, msgsz, msgflg,  msgp);
}

int msgrcv (int msqid, struct msgbuf *msgp, int msgsz, long msgtyp, int msgflg)
{
    struct ipc_kludge tmp;
    tmp.msgp = msgp;
    tmp.msgtyp = msgtyp;
    return ipc (MSGRCV, msqid, msgsz, msgflg, &tmp);
}

/* SHM SYSCALLS */
int shmget (key_t key, int size, int shmflg)
{
    return ipc (SHMGET, key, size, shmflg, NULL);
}

int shmctl (int shmid, int cmd, struct shmid_ds *buf)
{
    return ipc (SHMCTL, shmid, cmd, NONE, buf);
}

int shmdt (char *shmaddr)
{
    return ipc (SHMDT, NONE, NONE, NONE, shmaddr);
}

char *shmat (int shmid, char *shmaddr, int shmflg)
{
    int rval; ulong raddr;
    rval = ipc (SHMAT, shmid, shmflg, (int) &raddr, shmaddr);
    return rval < 0 ? (char *) rval : (char *) raddr;
}

key_t ftok (char *path, char id)
{
    struct stat buf;
    key_t key;

    if (stat (path, &buf)) {
	return (key_t) -1;
    }
    key = (buf.st_ino & 0xFFFF) | ((buf.st_uid & 0xFF) << 16) | (id << 24);
    return key;
}




