#include "stdioprivate.h"
#include <errno.h>
#include <procbuf.h>

extern "C" FILE * popen(const char *command, const char *mode)
{
    return (FILE*)(new procbuf(command, mode[0] == 'r' ? ios::in : ios::out));
}

extern "C" int pclose(FILE *stream)
{
#if 0
    if (stream is not a (procbuf*))
	return -1;
#endif
    // Does not actually test that stream was created by popen(). Instead,
    // it depends on the filebuf::sys_close() virtual to Do The Right Thing.
    if (!__validfp(stream) || !(stream->_flags & _S_IS_FILEBUF)) {
	errno = EINVAL;
	return EOF;
    }
    int status = (((filebuf *) stream)->close() == NULL)
		? EOF : ((procbuf *) stream)->exit_status ();
    if (stream != stdin && stream != stdout && stream != stderr)
	delete (filebuf*)stream;
    return status;
}
