.TH Connector 3U "20 August 1990" "Unidraw" "InterViews Reference Manual"
.SH NAME
Connector, ConnectorView \- base classes for connector subjects and views
.SH SYNOPSIS
.B #include <Unidraw/Components/connector.h>
.SH DESCRIPTION
Connector is an abstract base class for graphical component subjects
that enforce different connectivity semantics depending on the
particular connector subclass.  ConnectorView is the abstract base
class for views of connector subjects.  A connector can be connected
to one or more other connectors.  Once connected, two connectors can
affect each other's position in specific ways as defined by the
semantics of the connection.

Connectors also participate in the propagation of state variable
values during dataflow.  Two connected connectors with bound state
variables will assign the value of one state variable to other, and
the direction of transfer depends on the connectors' transmission
method.  For example, if the transmission method of connector C1 with
bound state variable S1 is In, and if the transmission method of
connector C2 with bound state variable S2 is Out, and if C1 and C2 are
connected, then S1 will be assigned the value of S2 during dataflow.
.SH CONNECTOR PUBLIC OPERATIONS
.TP
.B "virtual void Interpret(Command*)"
.ns
.TP
.B "virtual void Uninterpret(Command*)"
In addition to (un)interpreting the commands GraphicComp
(un)interprets, connectors also (un)interpret DeleteCmd and CutCmd to
sever and restore any connections to them.
.TP
.B "virtual void Connect(Connector*, CGlue* = nil);
Connect this connector to the given one, optionally with a piece of
CGlue interposed.  This operation allows redundant connections by
default.
.TP
.B "virtual void Disconnect(Connector*)"
.ns
.TP
.B "void DisconnectAll()"
Disconnect the given connector from this one, if they are connected.
DisconnectAll calls Disconnect on all connected connectors until no
connections remain.
.TP
.B "virtual boolean ConnectedTo(Connector*)"
Return whether this connector is connected to the given one.
.TP
.B "virtual void GetCenter(float&, float&)"
Return the coordinates of the connector's center, which defines its
position.
.TP
.B "virtual void SetBinding(StateVar*)"
.ns
.TP
.B "virtual StateVar* GetBinding()"
Assign and return the state variable bound to the connector, if any.
Only one state variable can be bound to a connector at a time.
.TP
.B "virtual void SetTransMethod(TransMethod)"
.ns
.TP
.B "virtual TransMethod GetTransMethod()"
Assign and return the connector's transmission method.
.TP
.B "virtual void Transmit(Path* = nil)"
Initiate dataflow originating from this connector, optionally based on
information supplied in the given path object.  Other Unidraw or
application objects call this operation whenever data modifications
should be propagated.
.SH CONNECTOR PROTECTED OPERATIONS
.TP
.B "Connector(Graphic* = nil)"
Initialize the connector instance, optionally with a graphic whose
center defines the connector's position.
.TP
.B "virtual void ConnectMe(Connector*)"
.ns
.TP
.B "virtual void DisconnectMe(Connector*)"
Connectors maintain a list of the connectors to which they are
connected.  The Connect and Disconnect operations update this
connector's list, while the ConnectMe and DisconnectMe operations
inform their argument to update their lists.
.TP
.B "void Retransmit(Path*)"
.ns
.TP
.B "void Retransmit(Connector* peer, Path*)"
.ns
.TP
.B "boolean Transferable(Connector* peer)"
The Transmit operation uses these operations to propagate state
variable values.  The first Retransmit function calls the second one
on each of the connector's peers (i.e., the connectors to which it is
connected) if the path records that this connector has not already
been visited (otherwise propagation ceases).  The first Retransmit
copies the path if necessary to avoid accumulating visit information
from multiple branches.  The second Retransmit calls Transferable,
which returns whether the value of this connector's state variable can
be transferred to the given peer's state variable based on the two
connectors' transmission methods.  If the values are transferable,
then the Transferable operation carries out the assignment to the
peer's state variable as a side-effect.  The second Retransmit also
enables further propagation by evaluating the transfer function of the
peer's parent and by calling the first Retransmit operation on the
peer.
.SH CONNECTORVIEW PUBLIC OPERATIONS
.TP
.B "Connector* GetConnector()"
Return the view's subject, if any.
.SH CONNECTORVIEW PROTECTED OPERATIONS
.TP
.B "ConnectorView(Connector* = nil)"
The constructor takes a subject as an optional argument.  The view
will attach itself to the subject if one is specified.
.SH SEE ALSO
CGlue(3U), GraphicComp(3U), GraphicView(3U), Path(3U), StateVar(3U),
edit(3U0, globals(3U)
