# include <stdio.h>
# include <errno.h>
# include <string.h>
# include <stdlib.h>
# include <fcntl.h>

# define BLOCK_SIZE		(32*1024)

char *progname = "readblock";

static char *dev_names[] = {
	"/dev/hda12",
	"/dev/hda13",
	"/dev/hda14",
	"/dev/hda15",
};

main (int argc, char **argv)
{
	unsigned long block;
	int dd_idx = -1, fd;
	long buf[BLOCK_SIZE / sizeof (long)];

	if (argc != 3) {
		fprintf (stderr, "Usage: %s <disk> <block>\n", progname);
		exit (1);
	}

	dd_idx = atol (argv[1]);
	if (dd_idx < 0 || dd_idx > 3) {
		fprintf (stderr, "%s: disk out of range 0-3 (%d)\n", progname,
		    dd_idx);
		exit (2);
	}

	block = (unsigned long) atol (argv[2]);

	if ((fd = open (dev_names[dd_idx], O_RDONLY)) < 0) {
		fprintf (stderr, "%s: can't open %s for reading (%s)\n",
		    progname, dev_names[dd_idx], strerror (errno));
		exit (3);
	}

	if (lseek (fd, block * BLOCK_SIZE, SEEK_SET) < 0) {
		fprintf (stderr, "%s: lseek failed (%s)\n", progname, 
		    strerror (errno));
		exit (4);
	}

	if (read (fd, (char *) buf, sizeof (buf)) < 0) {
		fprintf (stderr, "%s: read failed (%s)\n", progname, 
		    strerror (errno));
		exit (5);
	}

	close (fd);

	printf ("disk %d, block %lu, *block = %ld\n", dd_idx, block, *buf);

	exit (0);
}
