# /etc/rc
#
# These commands are executed at boot time by init(8).
# User customization should go in /etc/rc.local.

PATH=/sbin:/usr/sbin:/bin:/usr/bin

# enable swapping
/sbin/swapon -a

# Start update.
/sbin/update &

# Test to see if the root partition is read-only, like it ought to be.
READWRITE=no
if echo -n >> "Testing filesystem status"; then
 rm -f "Testing filesystem status"
 READWRITE=yes
fi

# Check the integrity of all filesystems
if [ ! $READWRITE = yes ]; then
 /sbin/fsck -A -a
 # If there was a failure, drop into single-user mode.
 if [ $? -gt 1 ] ; then
  echo
  echo
  echo "**************************************"
  echo "fsck returned error code - REBOOT NOW!"
  echo "**************************************"
  echo
  echo
  /bin/login 
 fi
 # Remount the root filesystem in read-write mode
 echo "Remounting root device with read-write enabled."
 /sbin/mount -w -n -o remount /
else
 cat << EOF

*** Root partition has already been mounted read-write. Cannot check!
For filesystem checking to work properly, your system must initially mount
the root partition as read only. Please modify your kernel with 'rdev' so that
it does this. If you're booting with LILO, type:
  rdev -R /vmlinuz 1
         (^^^^^^^^  ... or whatever your kernel name is.)

If you boot from a kernel on a floppy disk, put it in the drive and type:
  rdev -R /dev/fd0 1

This will fix the problem *AND* eliminate this annoying message. :^)

EOF
 sleep 10
fi

# remove /etc/mtab* so that mount will create it with a root entry
/bin/rm -f /etc/mtab* /etc/nologin /etc/utmp

# Looks like we have to create this.
cat /dev/null >> /etc/utmp

# mount file systems in fstab (and create an entry for /)
# but not NFS because TCP/IP is not yet configured
/sbin/mount -avt nonfs

# Configure the system clock.
# This can be changed if your system keeps GMT.
if [ -x /sbin/clock ]; then
  /sbin/clock -s
fi

# Setup the /etc/issue and /etc/motd to reflect the current kernel level:
# THESE WIPE ANY CHANGES YOU MAKE TO /ETC/ISSUE AND /ETC/MOTD WITH EACH
# BOOT. COMMENT THEM OUT IF YOU WANT TO MAKE CUSTOM VERSIONS.
echo > /etc/issue
echo Welcome to Linux `/bin/uname -a | /bin/cut -d\  -f3`. >> /etc/issue
echo >> /etc/issue
echo "`/bin/uname -a | /bin/cut -d\  -f1,3`. (Posix)." > /etc/motd

# Set up the serial ports.
# This made a couple machines I tested this on hang at this point in the boot
# process, so it's getting commented out by default. However, if you need to
set up extended serial ports try it out. It usually works great.
#/bin/sh /etc/rc.d/rc.serial

