#include <windows.h>

#define IDM_NEW 1
#define IDM_OPEN 2
#define IDM_SAVE 3
#define IDM_SAVEAS 4
#define IDM_EXIT 5
#define IDM_UNDO 10
#define IDM_CUT 11
#define IDM_COPY 12
#define IDM_PASTE 13
#define IDM_CLEAR 14
#define IDM_WHITE 20
#define IDM_LTGRAY 21
#define IDM_GRAY 22
#define IDM_DKGRAY 23
#define IDM_BLACK 24
#define IDM_START 30
#define IDM_STOP 31
#define IDM_HELP 40
#define IDM_ABOUT 41
#define IDM_TIMER 41


long FAR PASCAL WndProc(HWND handle, WORD msg, WORD wParam, LONG lParam);

char szAppName[]="MenuDemo";

int PASCAL WinMain(HANDLE hInstance, HANDLE hPrevInstance,
		   LPSTR lpszCmdLine, int nCmdShow)
	{
	HWND hwnd;
	MSG msg;
	WNDCLASS wndclass;
	HMENU hMenu,hMenuPopup;

	if(!hPrevInstance) {
		wndclass.style		= CS_HREDRAW | CS_VREDRAW;
		wndclass.lpfnWndProc	= WndProc;
		wndclass.cbClsExtra	= 0;
		wndclass.cbWndExtra	= 0;
		wndclass.hInstance	= hInstance;
		wndclass.hIcon		= LoadIcon(NULL, IDI_APPLICATION);
		wndclass.hCursor	= LoadCursor(NULL, IDC_ARROW);
		wndclass.hbrBackground	= GetStockObject(WHITE_BRUSH);
		wndclass.lpszMenuName	= szAppName;
		wndclass.lpszClassName	= szAppName;

		RegisterClass(&wndclass);
	}

	hwnd=CreateWindow(szAppName,  "Menu Demonstration",  WS_OVERLAPPEDWINDOW,
		CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT,
		NULL, NULL, hInstance, NULL );

hMenu = CreateMenu();
hMenuPopup = CreateMenu();

AppendMenu( hMenuPopup, MF_STRING,	IDM_NEW,	"&New");
AppendMenu( hMenuPopup, MF_STRING,	IDM_OPEN,	"&Open");
AppendMenu( hMenuPopup, MF_STRING,	IDM_SAVE,	"&Save");
AppendMenu( hMenuPopup, MF_STRING,	IDM_SAVEAS,	"Save &As...");
AppendMenu( hMenuPopup, MF_SEPARATOR,	0,		NULL);
AppendMenu( hMenuPopup, MF_STRING,	IDM_EXIT,	"E&xit");

AppendMenu( hMenu, MF_POPUP,	hMenuPopup,	"&File");
hMenuPopup = CreateMenu();

AppendMenu( hMenuPopup, MF_STRING,	IDM_UNDO,	"E&xit");
AppendMenu( hMenuPopup, MF_SEPARATOR,	0,		NULL);
AppendMenu( hMenuPopup, MF_STRING,	IDM_CUT,	"Cu&t");
AppendMenu( hMenuPopup, MF_STRING,	IDM_COPY,	"&Copy");
AppendMenu( hMenuPopup, MF_STRING,	IDM_PASTE,	"&Paste");
AppendMenu( hMenuPopup, MF_STRING,	IDM_CLEAR,	"C&lear");

AppendMenu( hMenu, MF_POPUP,	hMenuPopup,	"&Edit");
hMenuPopup = CreateMenu();

AppendMenu( hMenuPopup, MF_STRING|MF_CHECKED,	IDM_WHITE,	"&White");
AppendMenu( hMenuPopup, MF_STRING,	IDM_LTGRAY,	"&Lt Gray");
AppendMenu( hMenuPopup, MF_STRING,	IDM_GRAY,	"&Gray");
AppendMenu( hMenuPopup, MF_STRING,	IDM_DKGRAY,	"&Dk Gray");
AppendMenu( hMenuPopup, MF_STRING,	IDM_BLACK,	"&Black");

AppendMenu( hMenu, MF_POPUP,	hMenuPopup,	"&Background");
hMenuPopup = CreateMenu();

AppendMenu( hMenuPopup, MF_STRING,	IDM_START,	"&Start");
AppendMenu( hMenuPopup, MF_STRING|MF_GRAYED,	IDM_STOP,	"S&top");

AppendMenu( hMenu, MF_POPUP,	hMenuPopup,	"&Timer");
hMenuPopup = CreateMenu();

AppendMenu( hMenuPopup, MF_STRING,	IDM_HELP,	"&Help");
AppendMenu( hMenuPopup, MF_STRING,	IDM_ABOUT,	"&About MenuDemo...");

AppendMenu( hMenu, MF_POPUP,	hMenuPopup,	"&Help");

	ShowWindow(hwnd, nCmdShow);
	UpdateWindow(hwnd);

	Rectangle(hwnd,44,99,500,500);
	while(GetMessage(&msg,NULL,0,0)) {
		TranslateMessage(&msg);
		DispatchMessage(&msg);
	}
	return msg.wParam;
}

long FAR PASCAL WndProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)
{
	static int wColorID[5] = { WHITE_BRUSH, LTGRAY_BRUSH, GRAY_BRUSH,
					DKGRAY_BRUSH, BLACK_BRUSH };
	static WORD wSelection = IDM_WHITE;
	HMENU	hMenu;

	switch (message)
	{
	case WM_COMMAND:
		hMenu = GetMenu(hwnd);
		switch(wParam)
		{
		case IDM_NEW:
		case IDM_OPEN:
		case IDM_SAVE:
		case IDM_SAVEAS:
			MessageBeep(0);
			return 0;
		case IDM_EXIT:
			SendMessage(hwnd, WM_CLOSE, 0, 0L);
			return 0;
		case IDM_UNDO:
		case IDM_CUT:
		case IDM_COPY:
		case IDM_PASTE:
		case IDM_CLEAR:
			MessageBeep(0);
			return 0;
		case IDM_WHITE:
		case IDM_LTGRAY:
		case IDM_GRAY:
		case IDM_DKGRAY:
		case IDM_BLACK:
			CheckMenuItem(hMenu, wSelection, MF_UNCHECKED );
			wSelection = wParam;
			CheckMenuItem(hMenu, wSelection, MF_CHECKED);

			SetClassWord( hwnd, GCW_HBRBACKGROUND,
				GetStockObject(wColorID[wParam-IDM_WHITE]));
			InvalidateRect(hwnd, NULL, TRUE);
			return 0;
		case IDM_START:
			if (SetTimer(hwnd, 1, 1000, NULL))
			{
				EnableMenuItem(hMenu, IDM_START, MF_GRAYED);
				EnableMenuItem(hMenu, IDM_STOP, MF_ENABLED);
			}
			return 0;
		case IDM_STOP:
			KillTimer(hwnd, 1);
			EnableMenuItem(hMenu, IDM_START, MF_GRAYED);
			EnableMenuItem(hMenu, IDM_STOP, MF_ENABLED);
			return 0;
		case IDM_HELP:
			MessageBox(hwnd, "Help not yet implemented.",
				szAppName, MB_ICONINFORMATION | MB_OK );
			return 0;
		case IDM_ABOUT:
			MessageBox(hwnd, "Menu Demonstration Program.",
				szAppName, MB_ICONINFORMATION | MB_OK );
			return 0;
		}
	case IDM_TIMER:
		MessageBeep(0);
		return(0);
	case WM_DESTROY:
		PostQuitMessage(0);
		return 0;
	}
	return DefWindowProc(hwnd, message, wParam, lParam);
}

