#include <monetary.h>
#include <stdio.h>
#include <locale.h>

static int
check (const char *fmt, double n, const char *ok)
{
  int result;
  char buf[1000];

  strfmon (buf, sizeof buf, fmt, n);
  result = strcmp (buf, ok);

  if (result)
    printf ("strfmon(,,\"%s\",%g) = %s is not correct\n", fmt, n, buf);
  return result;
}

int
main()
{
  int result = 0;

  setlocale (LC_ALL, "en_US");

  result |= check ("%n", 123.45, " $123.45");
  result |= check ("%n", -123.45, "-$123.45");
  result |= check ("%n", 3456.781, " $3,456.78");

  result |= check ("%11n", 123.45, "    $123.45");
  result |= check ("%11n", -123.45, "   -$123.45");
  result |= check ("%11n", 3456.781, "  $3,456.78");

  result |= check ("%#5n", 123.45, " $   123.45");
  result |= check ("%#5n", -123.45, "-$   123.45");
  result |= check ("%#5n", 3456.781, " $ 3,456.78");

  result |= check ("%=*#5n", 123.45, " $***123.45");
  result |= check ("%=*#5n", -123.45, "-$***123.45");
  result |= check ("%=*#5n", 3456.781, " $*3,456.78");

  result |= check ("%=0#5n", 123.45, " $000123.45");
  result |= check ("%=0#5n", -123.45, "-$000123.45");
  result |= check ("%=0#5n", 3456.781, " $03,456.78");

  result |= check ("%^#5n", 123.45, " $  123.45");
  result |= check ("%^#5n", -123.45, "-$  123.45");
  result |= check ("%^#5n", 3456.781, " $ 3456.78");

  result |= check ("%^#5.0n", 123.45, " $  123");
  result |= check ("%^#5.0n", -123.45, "-$  123");
  result |= check ("%^#5.0n", 3456.781, " $ 3457");

  result |= check ("%^#5.4n", 123.45, " $  123.4500");
  result |= check ("%^#5.4n", -123.45, "-$  123.4500");
  result |= check ("%^#5.4n", 3456.781, " $ 3456.7810");

  result |= check ("%(#5n", 123.45, " $   123.45 ");
  result |= check ("%(#5n", -123.45, "($   123.45)");
  result |= check ("%(#5n", 3456.781, " $ 3,456.78 ");

  result |= check ("%!(#5n", 123.45, "    123.45 ");
  result |= check ("%!(#5n", -123.45, "(   123.45)");
  result |= check ("%!(#5n", 3456.781, "  3,456.78 ");

  return result;
}
