/*
 * Copyright 2000 Hans Reiser
 */
#include "fsck.h"

#define MAX_GEN_NUMBER 127


// looks for name in the directory dir, return 1 if name found, 0
// otherwise.
//
__u32 find_entry (struct key * dir, char * name)
{
    struct key entry_key;
    int retval;
    int i;
    INITIALIZE_PATH(path);

    entry_key.k_dir_id = dir->k_dir_id;
    entry_key.k_objectid = dir->k_objectid;
    set_offset (KEY_FORMAT_1, &entry_key, 
		GET_HASH_VALUE (reiserfs_hash (fs) (name, strlen (name))) + MAX_GEN_NUMBER);
    set_type (KEY_FORMAT_1, &entry_key, TYPE_DIRENTRY);
    
    while (1) {
	struct buffer_head * bh;
	struct item_head * ih;
	struct reiserfs_de_head * deh;

	retval = usearch_by_key (fs, &entry_key, &path);
	if (retval == ITEM_NOT_FOUND)
	    PATH_LAST_POSITION (&path) --;
	
	bh = PATH_PLAST_BUFFER (&path);
	ih = PATH_PITEM_HEAD (&path);
	if (!is_direntry_ih(ih)) {
	    pathrelse(&path) ;
	    return 0 ;
	}
	deh = B_I_DEH (bh, ih);

	for (i = ih->u.ih_entry_count - 1; i >= 0; i --) {
	    if (strlen (name) != name_length (ih, &deh[i], i))
		continue;
	    if (!memcmp (name_in_entry (&deh[i], i), name, strlen (name))) {
		pathrelse (&path);
		return deh[i].deh_objectid;;
	    }
	}
	pathrelse (&path);
	if (get_offset (&ih->ih_key) == DOT_OFFSET)
	    return 0;
	set_offset (KEY_FORMAT_1, &entry_key, get_offset (&entry_key) - 1);
    }
    die ("find_entry: endless loop broken");
    return 0;
}
    
#if 0
//
// add name pointing to 'key' to the directory 'dir'. FIXME: this will
// not work if there is a name in directory with the same value of
// hash function
//
void add_entry (struct key * dir, char * name, struct key * key, int lost_found)
{
    struct key entry_key;
    char * entry;
    struct reiserfs_de_head * deh;
    int retval;
    INITIALIZE_PATH(path);
    int paste_size;

    // compose entry key to look for its place in the tree
    entry_key.k_dir_id = dir->k_dir_id;
    entry_key.k_objectid = dir->k_objectid;
    /* FIXME: maybe set gen counter to 127 ? */
    entry_key.u.k_offset_v1.k_offset = GET_HASH_VALUE (reiserfs_hash (fs) (name, strlen (name)));
    entry_key.u.k_offset_v1.k_uniqueness = V1_DIRENTRY_UNIQUENESS;

    retval = usearch_by_entry_key (fs, &entry_key, &path);
    if (retval == POSITION_FOUND) {
	fsck_log ("add_entry: name \"%s\" exists\n", name);
	pathrelse (&path);
	return;
    }

    entry = getmem (DEH_SIZE + ROUND_UP (strlen (name)));
    deh = (struct reiserfs_de_head *)entry;
    deh->deh_location = 0;
    deh->deh_offset = cpu_to_le32 (entry_key.u.k_offset_v1.k_offset);
    deh->deh_state = 0;
    mark_de_visible (deh);
    if (lost_found)
	mark_de_lost_found (deh);
    /* put key (ino analog) to de */
    deh->deh_dir_id = cpu_to_le32 (key->k_dir_id);
    deh->deh_objectid = cpu_to_le32 (key->k_objectid);
    memcpy ((char *)(deh + 1), name, strlen (name));
   
    if (SB_VERSION(fs) == REISERFS_VERSION_2)
	paste_size = DEH_SIZE + ROUND_UP (strlen (name));
    else 
	paste_size = DEH_SIZE + strlen (name);
    reiserfsck_paste_into_item (&path, entry, paste_size);
}



// key of '/lost+found' directory
extern struct key g_lost_found;
#endif


/* find stat datas whch where not reached via semantic pass and link
   them to "lost+found" */
static int link_lost (reiserfs_filsys_t fs, struct buffer_head ** path, int h)
{
    int i;
    struct item_head * ih;
    struct buffer_head * bh = path[h];
    char lost_name[80];

    ih = B_N_PITEM_HEAD (bh, 0);
    for (i = 0; i < B_NR_ITEMS (bh); i ++, ih++) {
	if (is_stat_data_ih (ih) && !is_item_reachable (ih)) {
	    struct key key = {0, 0, {{0, 0},}};

	    sprintf (lost_name, "%u_%u", le32_to_cpu (ih->ih_key.k_dir_id),
		     le32_to_cpu (ih->ih_key.k_objectid));
	    /* entry in lost+found directory will point to this key */
	    key.k_dir_id = ih->ih_key.k_dir_id;
	    key.k_objectid = ih->ih_key.k_objectid;

	    /* 0 does not mean anyting - item w/ "." and ".." already
               exists and reached, so only name will be added */
	    reiserfs_add_entry (fs, &lost_found_dir_key, lost_name, &key, 0, 1/*lost&found*/);
	    stat_lost_found (fs);
	}
    }
    return 0;
}


void pass_3a_look_for_lost (reiserfs_filsys_t s)
{
    if (!lost_found_dir_key.k_objectid) {
	fsck_progress ("look_for_lost: could not create lost+found directory\n");
	return;
    }

    /* pass through the tree and link stat data which were not reached
       yet to /lost+found */
    fsck_progress ("Looking for lost files..");
    pass_through_tree (s, 0, link_lost);
    fsck_progress ("ok\n");

    /* check names added we just have added to/lost+found. Those names
       are marked DEH_Lost_found flag */
    fsck_progress ("Checking lost+found directory.."); fflush (stdout);
    check_semantic_tree (&lost_found_dir_key, &root_dir_key, 0, 1/* lost+found*/);
    fsck_progress ("ok\n");

    stage_report (0x3a, fs);
}
