
/*
 * Copyright 1996-1999 Hans Reiser
 */
#include "fsck.h"
#include <stdarg.h>


int fsck_user_confirmed (reiserfs_filsys_t fs, char * q, char * a, int default_answer)
{
    if (!fsck_interactive (fs))
	return default_answer;
    
    return user_confirmed (q, a);
}


void stage_report (int pass, reiserfs_filsys_t fs)
{
    FILE * fp;
    char buf[160];
    struct fsck_data * stat;

    stat = stats (fs);
    fp = stderr;
    
    switch (pass) {
    case 0:
	fprintf (fp, "Pass 0:\n");
	fprintf (fp, "\tblocks marked used %lu\n", stat->used);
	fprintf (fp, "\t\tleaves %lu\n", stat->leaves);
	fprintf (fp, "\t\t\tleaves pointed by indirect items %lu\n", stat->pointed_leaves);
	fprintf (fp, "\t\tblocks pointed by indirect items %lu\n", stat->pointed);
	fprintf (fp, "\t\t\tonce %lu\n", stat->pointed_once);
	fprintf (fp, "\t\t\tmore than once %lu\n", stat->pointed_more_than_once);
	fprintf (fp, "\tblocks marked free %lu\n", stat->free);
	fprintf (fp, "\tallocable %lu blocks\n", stat->allocable);
	break;

    case 1:
	fprintf (fp, "Pass 1:\n");
	fprintf (fp, "\t%lu leaves read\n", stat->read_leaves);
	fprintf (fp, "\t\t%lu inserted\n", stat->inserted_leaves);
	fprintf (fp, "\t\t%lu not inserted\n", stat->uninsertable_leaves);
	fprintf (fp, "\tSaved %lu items\n", stat->saved_on_pass1);
	break;

    case 2:
	fprintf (fp, "Pass 2:\n");
	fprintf (fp, "\t%lu shared objectids\n", stat->shared_objectids);
	return;

    case 3: /* semantic pass */
	fprintf (fp, "Pass 3:\n");
	fprintf (fp, "\tFiles found: %d\n", stat->regular_files);
	fprintf (fp, "\tDirectories found: %d\n", stat->directories);
	fprintf (fp, "\tSymlinks found: %d\n", stat->symlinks);
	fprintf (fp, "\tOthers: %d\n", stat->others);
	fprintf (fp, "\tFiles with fixed size: %d\n", stat->fixed_sizes);
	break;

    case 0x3a: /* looking for lost files */
	fsck_progress ("Pass 3a:\nLinked to /lost+found directory %d file/dirs:\n",
		       stat->lost_found);
	break;

    case 4: /* removing of unreachable */
	fsck_progress ("Pass 4\nDeleted unreachable items %lu\n",
		       stat->deleted_items);
	break;
    }

    if (!fsck_user_confirmed (fs, "Continue? (Yes):", "Yes\n", 1)) {
	reiserfs_close (fs);
	exit (0);
    }
}


