/*
 * Copyright 1996, 1997, 1998 Hans Reiser
 */
#include "fsck.h"


static void get_next_key (struct path * path, int i, struct key * key)
{
    struct buffer_head * bh = PATH_PLAST_BUFFER (path);
    struct key maxkey;
    struct key * rkey;

    memset (&maxkey, 0xff, KEY_SIZE);
    if (i < B_NR_ITEMS (bh) - 1) {
	copy_key (key, B_N_PKEY (bh, i + 1));
	return;
    }

    rkey = uget_rkey (path);
    if (rkey) {
	copy_key (key, rkey);
    } else {
	copy_key (key, &maxkey);
    }
}

/* this is pass 4 */
int pass_4_check_unaccessed_items (void)
{
    struct key key;
    struct path path;
    int i;
    struct buffer_head * bh;
    struct item_head * ih;
    unsigned long passed = 0;
    __u32 * p;
    int length = REISERFS_FULL_KEY_LEN;

    path.path_length = ILLEGAL_PATH_ELEMENT_OFFSET;
    copy_key (&key, &root_directory_key);
    
    fsck_progress ("Pass 4 - ");

    while (usearch_by_key (fs, &key, &path) == ITEM_FOUND) {
	bh = PATH_PLAST_BUFFER (&path);
	for (i = get_item_pos (&path), ih = get_ih (&path); i < B_NR_ITEMS (bh); i ++, ih ++) {
	    if (!is_item_reachable (ih)) {

		get_next_key (&path, i, &key);

		stat_item_deleted(fs);
	
		PATH_LAST_POSITION (&path) = i;
		reiserfsck_delete_item (&path, 0);

		goto cont;
	    }
#if 0
	    if ((is_stat_data_ih (ih)) && opt_fsck == 0) {
		print_how_far (&passed, 0/*get_event (STAT_DATA_ITEMS)*/);
	    }
#endif
	}
	get_next_key (&path, i - 1, &key);
	pathrelse (&path);

    cont:
    }

    pathrelse (&path);

    fsck_progress ("done\n");
    stage_report (4, fs);

    return 0;
}
