/*
 * Copyright 2000 Hans Reiser
 */
#include "fsck.h"

#define MAX_GEN_NUMBER 127
//
// looks for name in the directory dir, return 1 if name found, 0
// otherwise.
//
__u32 find_entry (struct key * dir, char * name)
{
    struct key entry_key;
    int retval;
    int i;
    INITIALIZE_PATH(path);

    entry_key.k_dir_id = dir->k_dir_id;
    entry_key.k_objectid = dir->k_objectid;
    set_offset (KEY_FORMAT_1, &entry_key, 
		GET_HASH_VALUE (reiserfs_hash (fs) (name, strlen (name))) + MAX_GEN_NUMBER);
    set_type (KEY_FORMAT_1, &entry_key, TYPE_DIRENTRY);
    
    while (1) {
	struct buffer_head * bh;
	struct item_head * ih;
	struct reiserfs_de_head * deh;

	retval = usearch_by_key (fs, &entry_key, &path);
	if (retval == ITEM_NOT_FOUND)
	    PATH_LAST_POSITION (&path) --;
	
	bh = PATH_PLAST_BUFFER (&path);
	ih = PATH_PITEM_HEAD (&path);
	deh = B_I_DEH (bh, ih);
	for (i = ih->u.ih_entry_count - 1; i >= 0; i --) {
	    if (strlen (name) != name_length (ih, &deh[i], i))
		continue;
	    if (!memcmp (name_in_entry (&deh[i], i), name, strlen (name))) {
		pathrelse (&path);
		return deh[i].deh_objectid;;
	    }
	}
	pathrelse (&path);
	if (get_offset (&ih->ih_key) == DOT_OFFSET)
	    return 0;
	set_offset (KEY_FORMAT_1, &entry_key, get_offset (&entry_key) - 1);
    }
    die ("find_entry: endless loop broken");
    return 0;
}
    

//
// add name pointing to 'key' to the directory 'dir'. FIXME: this will
// not work if there is a name in directory with the same value of
// hash function
//
void add_entry (struct key * dir, char * name, struct key * key, int lost_found)
{
    struct key entry_key;
    char * entry;
    struct reiserfs_de_head * deh;
    int retval;
    INITIALIZE_PATH(path);
    int paste_size;

    // compose entry key to look for its place in the tree
    entry_key.k_dir_id = dir->k_dir_id;
    entry_key.k_objectid = dir->k_objectid;
    /* FIXME: maybe set gen counter to 127 ? */
    entry_key.u.k_offset_v1.k_offset = GET_HASH_VALUE (reiserfs_hash (fs) (name, strlen (name)));
    entry_key.u.k_offset_v1.k_uniqueness = V1_DIRENTRY_UNIQUENESS;

    retval = usearch_by_entry_key (fs, &entry_key, &path);
    if (retval == POSITION_FOUND) {
	fsck_log ("add_entry: name \"%s\" exists\n", name);
	pathrelse (&path);
	return;
    }

    entry = getmem (DEH_SIZE + ROUND_UP (strlen (name)));
    deh = (struct reiserfs_de_head *)entry;
    deh->deh_location = 0;
    deh->deh_offset = cpu_to_le32 (entry_key.u.k_offset_v1.k_offset);
    deh->deh_state = 0;
    mark_de_visible (deh);
    if (lost_found)
	mark_de_lost_found (deh);
    /* put key (ino analog) to de */
    deh->deh_dir_id = cpu_to_le32 (key->k_dir_id);
    deh->deh_objectid = cpu_to_le32 (key->k_objectid);
    memcpy ((char *)(deh + 1), name, strlen (name));
   
    if (SB_VERSION(fs) == REISERFS_VERSION_2)
	paste_size = DEH_SIZE + ROUND_UP (strlen (name));
    else 
	paste_size = DEH_SIZE + strlen (name);
    reiserfsck_paste_into_item (&path, entry, paste_size);
}

#if 0
static void zero_nlink (int old, void * sd)
{
    if (old) {
	struct stat_data_v1 * sd_v1 = sd;

	sd_v1->sd_nlink = 0;
    } else {
	struct stat_data * sd_v2 = sd;

	sd_v2->sd_nlink = 0;
    }
}

static int not_a_directory (void * sd)
{
    /* mode is at the same place and of the same size in both stat
       datas (v1 and v2) */
    struct stat_data_v1 * sd_v1 = sd;

    return !(S_ISDIR (le16_to_cpu (sd_v1->sd_mode)));
}


/* mkreiserfs should have created this */
static __u32 make_lost_found_dir (struct key * lost_found_key)
{
    int retval;
    INITIALIZE_PATH (path);
    struct stat_data sd;
    struct item_head ih;
    char empty [EMPTY_DIR_SIZE];
    __u32 lost_found; // objectid of directory "/lost+found"
    int key_format;


    if (SB_VERSION(fs) == REISERFS_VERSION_2)
	key_format = KEY_FORMAT_2;
    else 
	key_format = KEY_FORMAT_1;

    /* look for "lost+found" in the root directory */
    lost_found_key->k_objectid = find_entry (&root_key, "lost+found");
    if (lost_found_key->k_objectid) {
	retval = usearch_by_key (fs, lost_found_key, &path);
	if (retval != ITEM_FOUND || not_a_directory (get_item (&path))) {
	    fsck_progress ("make_lost_found_dir: \"lost+found\" points to nothing or is not a directory\n");
	    lost_found_key->k_objectid = 0;
	}
	pathrelse (&path);
	return lost_found_key->k_objectid;
    }

    // key of the stat data
    lost_found_key->k_objectid = get_unused_objectid (fs);
    if (!lost_found_key->k_objectid)
	return 0;
    
    /* compose item to insert: ih and stat data body */
    make_dir_stat_data (key_format, lost_found_key->k_dir_id, 
			lost_found_key->k_objectid, &ih, (char *)&sd);
    zero_nlink (key_format == KEY_FORMAT_1, &sd);
    
    retval = usearch_by_key (fs, lost_found_key, &path);
    if (retval != ITEM_NOT_FOUND)
	return 0;
    
    mark_item_unreachable (&ih);
    reiserfsck_insert_item (&path, &ih, (char *)&sd);
    
    /* compose empty dir item and its item_head */
    set_offset (KEY_FORMAT_1, &ih.ih_key, DOT_OFFSET);
    set_type (KEY_FORMAT_1, &ih.ih_key, TYPE_DIRENTRY);
    ih.u.ih_entry_count = cpu_to_le16 (2);

    if (key_format == KEY_FORMAT_1) {
	ih.ih_item_len = cpu_to_le16 (EMPTY_DIR_SIZE_V1);
	make_empty_dir_item_v1 (empty, lost_found_key->k_dir_id, lost_found_key->k_objectid,
				REISERFS_ROOT_PARENT_OBJECTID, REISERFS_ROOT_OBJECTID);
    } else {
	ih.ih_item_len = cpu_to_le16 (EMPTY_DIR_SIZE);
	make_empty_dir_item (empty, lost_found_key->k_dir_id, lost_found_key->k_objectid,
			     REISERFS_ROOT_PARENT_OBJECTID, REISERFS_ROOT_OBJECTID);
    }

    // look for place to insert it
    set_offset (KEY_FORMAT_1, lost_found_key, DOT_OFFSET);
    set_type (KEY_FORMAT_1, lost_found_key, TYPE_DIRENTRY);
    retval = usearch_by_key (fs, lost_found_key, &path);
    if (retval != ITEM_NOT_FOUND)
	die ("make_lost_found_dir: can not create empty dir body of \'lost+found\'");

    mark_item_unreachable (&ih);
    reiserfsck_insert_item (&path, &ih, empty);

    // add entry to the root directory
    add_entry (&root_key, "lost+found", lost_found_key);

    /* update root directory */
    if (usearch_by_key (fs, &root_key, &path) != ITEM_FOUND)
	die ("make_lost_found_dir: can not find root directory");
    if (ih_key_format (get_ih (&path)) == KEY_FORMAT_1) {
	struct stat_data_v1 * root_sd = get_item (&path);

	root_sd->sd_size = cpu_to_le32 (le32_to_cpu (root_sd->sd_size) + DEH_SIZE + strlen ("lost+found"));
	root_sd->sd_nlink = cpu_to_le16 (le16_to_cpu (root_sd->sd_nlink) + 1);
    } else {
	struct stat_data * root_sd = get_item (&path);

	root_sd->sd_size = cpu_to_le64 (le64_to_cpu (root_sd->sd_size) + DEH_SIZE + strlen ("lost+found"));
	root_sd->sd_nlink = cpu_to_le32 (le32_to_cpu (root_sd->sd_nlink) + 1);
    }
    // FIXME: sd_blocks left unchanged
    mark_buffer_dirty (get_bh (&path));
    pathrelse (&path);

    set_offset (KEY_FORMAT_1, lost_found_key, SD_OFFSET);
    set_type (KEY_FORMAT_1, lost_found_key, TYPE_STAT_DATA);

    return lost_found_key->k_objectid;
}
#endif


// key of '/lost+found' directory
extern struct key g_lost_found;


// FIXME: link only directories
static int link_lost (struct super_block * s, struct buffer_head ** path, int h)
{
    int i;
    struct item_head * ih;
    struct buffer_head * bh = path[h];
    char lost_name[80];

    ih = B_N_PITEM_HEAD (bh, 0);
    for (i = 0; i < B_NR_ITEMS (bh); i ++, ih++) {
	if (is_stat_data_ih (ih) && !is_item_reachable (ih)) {// && S_ISDIR (B_I_STAT_DATA (bh, ih)->sd_mode)) {
	    struct key key = {0, 0, {{0, 0},}};

	    sprintf (lost_name, "%u_%u", le32_to_cpu (ih->ih_key.k_dir_id),
		     le32_to_cpu (ih->ih_key.k_objectid));
	    /* entry in lost+found directory will point to this key */
	    key.k_dir_id = ih->ih_key.k_dir_id;
	    key.k_objectid = ih->ih_key.k_objectid;
	    add_entry (&lost_found_dir_key, lost_name, &key, 1);
	    stat_lost_found(s);
	}
    }
    return 0;
}


void look_for_lost (struct super_block * s)
{
    struct buffer_head * path[MAX_HEIGHT] = {0,};
    int total[MAX_HEIGHT] = {0,};
    int cur[MAX_HEIGHT] = {0,};
    int h = 0;
    blocknr_t block = SB_ROOT_BLOCK (s);


    if (!lost_found_dir_key.k_objectid) {
	fsck_progress ("look_for_lost: could not create lost+found directory\n");
	return;
    }

/*
    fsck_progress ("Do not look for lost things (not ready)\n");
    return;
*/
#if 0
    if (!s->s_hash_function) {
	s->s_hash_function = keyed_hash;
	set_hash (s->s_rs, TEA_HASH);
	reiserfs_warning ("look_for_lost: do not know which hash is used to sort names, using default\n");
    }

    /* create lost+found directory (if it is not there) */
    g_lost_found.k_dir_id = root_key.k_objectid;
    g_lost_found.k_objectid = make_lost_found_dir (&g_lost_found);
    if (!g_lost_found.k_objectid) {
	fsck_progress ("look_for_lost: could not create lost+found directory\n");
	return;
    }
#endif

    fsck_progress ("Looking for lost files..");
    //fsck_stage(s) = STAGE_LOOKING_FOR_LOST;

    pass_through_tree (s, 0, link_lost);

    fsck_progress ("ok\n");

    /* we have passed whole tree once again. Something have been added
       to the lost+found directory. Do semantic pass for it */
    fsck_progress ("Checking lost+found directory.."); fflush (stdout);

    //    set_offset (KEY_FORMAT_1, &g_lost_found, SD_OFFSET);
    //set_type (KEY_FORMAT_1, &g_lost_found, TYPE_STAT_DATA);
    check_semantic_tree (&lost_found_dir_key, &root_directory_key, 0, 1/* lost+found*/);
    fsck_progress ("ok\n");

    stage_report (0x3a, fs);
}
