
/*
 * Copyright 1996-1999 Hans Reiser
 */
#include "fsck.h"
#include <stdarg.h>



void stage_report (int pass, struct super_block * s)
{
    FILE * fp;
    char buf[160];
    
    fp = stderr;
    
    switch (pass) {
    case 0:
	fprintf (fp, "Pass 0:\n");
	fprintf (fp, "\tblocks marked used %lu\n", stats (s)->used);
	fprintf (fp, "\t\tleaves %lu\n", stats (s)->leaves);
	fprintf (fp, "\t\t\tleaves pointed by indirect items %lu\n", stats (s)->pointed_leaves);
	fprintf (fp, "\t\tblocks pointed by indirect items %lu\n", stats (s)->pointed);
	fprintf (fp, "\t\t\tonce %lu\n", stats (s)->pointed_once);
	fprintf (fp, "\t\t\tmore than once %lu\n", stats (s)->pointed_more_than_once);
	fprintf (fp, "\tblocks marked free %lu\n", stats (s)->free);
	fprintf (fp, "\tallocable %lu blocks\n", stats (s)->allocable);
	break;

    case 1:
	fprintf (fp, "Pass 1:\n");
	fprintf (fp, "\t%lu leaves read\n", stats (s)->read_leaves);
	fprintf (fp, "\t\t%lu inserted\n", stats (s)->inserted_leaves);
	fprintf (fp, "\t\t%lu not inserted\n", stats (s)->uninsertable_leaves);
	fprintf (fp, "\tSaved %lu items\n", stats (s)->saved_on_pass1);
	break;

    case 2:
	fprintf (fp, "Pass 2:\n");
	fprintf (fp, "\t%lu shared objectids\n", stats (s)->shared_objectids);
	return;

    case 3: /* semantic pass */
	fprintf (fp, "Pass 3:\n");
	fprintf (fp, "\tFiles found: %d\n", stats (s)->regular_files);
	fprintf (fp, "\tDirectories found: %d\n", stats (s)->directories);
	fprintf (fp, "\tSymlinks found: %d\n", stats (s)->symlinks);
	fprintf (fp, "\tOthers: %d\n", stats (s)->others);
	fprintf (fp, "\tFiles with fixed size: %d\n", stats(s)->fixed_sizes);
	break;

    case 0x3a: /* looking for lost files */
	fsck_progress ("Pass 3a:\nLinked to /lost+found directory %d file/dirs:\n",
		       stats(s)->lost_found);
	break;

    case 4: /* removing of unreachable */
	fsck_progress ("Pass 4\nDeleted unreachable items %lu\n",
		       stats(s)->deleted_items);
	break;
    }

    if (!user_confirmed ("Continue? (Yes):", "Yes\n")) {
	reiserfs_close (fs);
	exit (0);
    }
}


