/*
 * Copyright 2000-2001 Hans Reiser
 */

#include "tune.h"

#if 0
int get_transaction (reiserfs_filsys_t * fs, reiserfs_trans_t * trans)
{
    struct buffer_head * d_bh;
//    struct buffer_head * next_d_bh;
    struct reiserfs_journal_desc * desc;
    int found;
//    unsigned long j_start;
//    unsigned long j_offset;
//    unsigned long block;

    found = -1;

    /* make sure that 'trans' is a valid transaction */
    d_bh = bread (fs->fs_journal_dev, trans->desc_blocknr, fs->fs_blocksize);
 
    if (is_valid_transaction (fs, d_bh)){

        desc = (struct reiserfs_journal_desc *)d_bh->b_data;
    
        if (trans->mount_id == get_jdesc_mount_id (desc) &&
            trans->trans_id == get_jdesc_trans_id (desc)) {
            trans->desc_blocknr = d_bh->b_blocknr;
            trans->trans_len = get_jdesc_len (desc);
            trans->commit_blocknr = commit_expected (fs, d_bh);
            found =  next_desc_expected (fs, d_bh);;
        } else {
            found = 0;
        }
    }
    brelse (d_bh);
    return found;
}


int reiserfs_check_for_replay_journal (reiserfs_filsys_t * fs, int option)
{
    struct buffer_head * bh;
    struct reiserfs_journal_header * j_head;
    reiserfs_trans_t cur, control;
    __u32 next_desc;
    int trans_count;

    bh = bread (fs->fs_journal_dev, get_jp_journal_1st_block (sb_jp (fs->fs_ondisk_sb)) +
		get_jp_journal_size (sb_jp (fs->fs_ondisk_sb)),
		fs->fs_blocksize);
    if (!bh) {
        message ("Could not read journal header\n");
        return 0;
    }

    j_head = (struct reiserfs_journal_header *)(bh->b_data);
    control.mount_id = get_jh_mount_id (j_head);
    control.trans_id = get_jh_last_flushed (j_head);
    control.desc_blocknr = get_jp_journal_1st_block (sb_jp (fs->fs_ondisk_sb)) +
        get_jh_replay_start_offset (j_head);
    if (!control.mount_id && !control.trans_id && control.desc_blocknr==get_jp_journal_1st_block
        (sb_jp (fs->fs_ondisk_sb)) || reiserfs_is_fs_consistent(fs) ) {
        return 0;
    }
    control.trans_id++;
    memcpy(&cur,&control,sizeof(reiserfs_trans_t));
    trans_count = 0;
    while ((next_desc=get_transaction (fs, &cur))>=0) {
        if (option) {
            replay_one_transaction (fs, &cur);
            set_jh_last_flushed (j_head, cur.trans_id);
            mark_buffer_dirty (bh);
            bwrite(bh);
        }
        trans_count++;
        cur.trans_id++;
        cur.desc_blocknr = next_desc;
    }
    brelse (bh);
    if (trans_count) {
        die ("journal: a valid transaction is found: check it with fsck");        
    }
    return 0;
}
#endif
