/*
 * Copyright 2000-2001 Hans Reiser
 */

#include "fsck.h"


/* fixme: what should be done when not all transactions can be replayed in
   proper order? */
int reiserfs_replay_journal (reiserfs_filsys_t * fs)
{
    struct buffer_head * bh;
    struct reiserfs_journal_header * j_head;
    reiserfs_trans_t cur, newest, control;
    int replayed;


    if (!reiserfs_journal_opened (fs)) {
	if (fsck_skip_journal (fs))
	    return 0;
	reiserfs_panic ("reiserfs_replay_journal: journal is not opened");
    }

    if (!is_opened_rw (fs))
	reiserfs_panic ("reiserfs_replay_journal: fs is not opened with write perms");

    fsck_progress ("Replaying journal..\n");
    bh = fs->fs_jh_bh;

    j_head = (struct reiserfs_journal_header *)(bh->b_data);
    control.mount_id = get_jh_mount_id (j_head);
    control.trans_id = get_jh_last_flushed (j_head);
    control.desc_blocknr = get_jh_replay_start_offset (j_head);

    if (!get_boundary_transactions (fs, &cur, &newest)) {
	fsck_progress ("No transactions found\n");
	return 0;
    }

    if (control.mount_id != newest.mount_id) {
	fsck_progress ("Journal header's mountid: %lu\n"
		       "latest transaction found is of mountid %lu\n",
		       control.mount_id, newest.mount_id);
	if (user_confirmed (stderr, "Should those transactions be replayed?(y/n)", "y")) {
	    control.mount_id = newest.mount_id;
	    control.trans_id = 0;
	}
    }

    replayed = 0;
    while (1) {
	if (cur.mount_id == control.mount_id &&
	    cur.trans_id > control.trans_id) {

	    fsck_log ("trans replayed: mountid %lu, transid %lu, desc %lu, "
		      "len %lu, commit %lu, next trans offset %lu\n",
		      cur.mount_id, cur.trans_id, cur.desc_blocknr, cur.trans_len,
		      cur.commit_blocknr, cur.next_trans_offset);
	    replay_one_transaction (fs, &cur);
	    
	    /* update journal header */
	    set_jh_last_flushed (j_head, cur.trans_id);
	    set_jh_mount_id (j_head, cur.mount_id);
	    set_jh_replay_start_offset (j_head, cur.next_trans_offset);
	    mark_buffer_dirty (bh);
	    bwrite (bh);
	    replayed ++;
	}
	if (!next_transaction (fs, &cur))
	    break;
    }
    fsck_progress ("%d transactions replayed\n", replayed);

    return 0;
}
