/*
 * Copyright 2000 by Hans Reiser, licensing governed by reiserfs/README
 */

#define _GNU_SOURCE
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <time.h>
#include <malloc.h>
#include <sys/types.h>
#include <asm/types.h>
#include <sys/stat.h>
#include <fcntl.h>

#include "io.h"
#include "misc.h"
#include "reiserfs_lib.h"
#include "../version.h"



/*
 *  modes
 */
#define DO_DUMP 1  /* not a real dump, just printing to stdout contents of
                      tree nodes */
#define DO_CORRUPT 2 /* used to make filesystem corruption and then test fsck */
#define DO_SCAN 3
#define DO_SCAN_FOR_NAME 4
#define DO_RECOVER 5
#define DO_TEST 6
#define DO_PACK 7  /* -p extract meta data of reiserfs filesystem */
#define DO_PACK_ALL 8 /* -p */

/* options */
#define PRINT_DETAILS 1
#define PRINT_JOURNAL 2
#define PRINT_BITMAP 4
#define PRINT_OBJECTID_MAP 8
#define BE_QUIET 16



// the leaf is stored in compact form: 
// start magic number
// block number __u32
// item number __u16
// struct packed_item
// ..
// end magic number

/* we store hash code in high byte of 16 bits */
#define LEAF_START_MAGIC 0xa6
#define LEAF_END_MAGIC 0x5a



#define FULL_BLOCK_START_MAGIC 0xb6
#define FULL_BLOCK_END_MAGIC 0x6b
#define UNFORMATTED_BITMAP_START_MAGIC 0xc7
#define UNFORMATTED_BITMAP_END_MAGIC 0x7c
#define END_MAGIC 0x8d
#define INTERNAL_START_MAGIC
#define INTERNAL_START_MAGIC


#define ITEM_START_MAGIC 0x476576
#define ITEM_END_MAGIC 0x2906504

/* 19 bits of mask are used to define */
#define NEW_FORMAT 1      /* 1. 0 here means - old format, 1 - new format */
#define DIR_ID 2          /* 2. dir_id is stored */
#define OBJECT_ID 4       /* 3. objectid is stored */
#define OFFSET_BITS_32 8  /* 4. offset is stored as 32 bit */
#define OFFSET_BITS_64 16 /* 5. offset is stored as 64 bit */
#define IH_ENTRY_COUNT 32    /* 6. ih_free_space/ih_entry_count is stored */
#define IH_FREE_SPACE 32
#define IH_FORMAT 64      /* 7. ih_format is stored */

#define WITH_SD_FIRST_DIRECT_BYTE 128 /* 8. for old stat data
					 first_direct_byte is stored */
#define NLINK_BITS_32 256 /* 9. nlinks stored in 32 bits */
#define SIZE_BITS_64 512  /* 10. size has to be stored in 64 bit */
#define WHOLE_INDIRECT 1024 /* 11. indirect item is stored with compression */


struct packed_item {
    __u32 type : 2;
    __u32 mask : 18; /* what is stored: dirid, objectid, 32 bit offset
			or 64 bit offset, type, etc */
    __u32 item_len : 12; /* item length in a node */
};


#define HAS_DIR_ID 1
#define HAS_GEN_COUNTER 2
#define HAS_STATE 4
#define YURA 8
#define TEA 16
#define R5 32
struct packed_dir_entry {
    __u8 mask;
    __u16 entrylen;
};


#define fread8(pv) fread (pv, sizeof (__u8), 1, stdin)
#define fread16(pv) fread (pv, sizeof (__u16), 1, stdin)
#define fread32(pv) fread (pv, sizeof (__u32), 1, stdin)
#define fread64(pv) fread (pv, sizeof (__u64), 1, stdin)

#define fwrite8(pv) {\
if (fwrite (pv, sizeof (__u8), 1, stdout) != 1)\
    reiserfs_panic ("fwrite8 failed: %m");\
sent1 ++;\
}
#define fwrite16(pv) {\
if (fwrite (pv, sizeof (__u16), 1, stdout) != 1)\
    reiserfs_panic ("fwrite16 failed: %m");\
sent1 += 2;\
}
#define fwrite32(pv) {\
if (fwrite (pv, sizeof (__u32), 1, stdout) != 1)\
    reiserfs_panic ("fwrite32 failed: %m");\
sent1 += 4;\
}
#define fwrite64(pv) {\
if (fwrite (pv, sizeof (__u64), 1, stdout) != 1)\
    reiserfs_panic ("fwrite64 failed: %m");\
sent1 += 8;\
}

/*
#define fwrite16(pv) fwrite (pv, sizeof (__u16), 1, stdout)
#define fwrite32(pv) fwrite (pv, sizeof (__u32), 1, stdout)
#define fwrite64(pv) fwrite (pv, sizeof (__u64), 1, stdout)
*/


#define BLOCKS_PER_READ 8

struct debugreiserfs_data {
    int mode; /* either DO_PACK, DO_CORRUPT */
#define USED_BLOCKS 1
#define EXTERN_BITMAP 2
#define ALL_BLOCKS 3
    int scan_area; /* for -p and -s */
    char * input_bitmap;
    char * output_bitmap;
    unsigned long block; /* to deal with */
    unsigned long options;
    reiserfs_bitmap_t bitmap;
};

#define data(s) ((struct debugreiserfs_data *)((s)->s_vp))

#define debug_mode(fs) (data(fs)->mode)
#define certain_block(fs) (data(fs)->block)
#define debug_bitmap(fs) (data(fs)->bitmap)
#define input_bitmap_file_name(fs) (data(fs)->input_bitmap)
#define output_bitmap_file_name(fs) (data(fs)->output_bitmap)
#define scan_area(fs) (data(fs)->scan_area)

#define be_quiet(fs)  (data(fs)->options & BE_QUIET)
