/*
 * Copyright 2002-2003 Hans Reiser
 */

#include "debugreiserfs.h"


extern unsigned long * badblocks;
extern int badblocks_nr;

#define BLOCK_IN_Q 12762

static void check_block_9555 (reiserfs_filsys_t * fs, reiserfs_trans_t * trans,
			      int index,
			      unsigned long in_journal, unsigned long in_place)
{
    struct buffer_head * bh;
    

    if (in_place == 17) {
	/* read block of journal which contains block 17 abd check whether bit
	   BLOCK_IN_Q is set */
	bh = bread (fs->fs_journal_dev, in_journal, fs->fs_blocksize);
	if (!bh) {
	    reiserfs_warning (stderr, "could not read block %lu (of journal area)\n",
			      in_journal);
	    return;
	}
	
	if (misc_test_bit (BLOCK_IN_Q, bh->b_data))
	    reiserfs_warning (stdout, "trans %lu, pos %d - block 17: block %d is marked used in it\n",
			      trans->trans_id, index, BLOCK_IN_Q);
	else
	    reiserfs_warning (stdout, "trans %lu, pos %d - block 17: block %d is marked free in it\n",
			      trans->trans_id, index, BLOCK_IN_Q);
	brelse (bh);
    }

    if (in_place == BLOCK_IN_Q) {
	reiserfs_warning (stdout, "trans %lu, block %d is logged at pos %d\n",
			  trans->trans_id, BLOCK_IN_Q, index);
    }
}


/* remove when the problem is found */
static void check_transaction (reiserfs_filsys_t * fs, reiserfs_trans_t * trans)
{
    for_each_block (fs, trans, check_block_9555);
}


void scan_journal (reiserfs_filsys_t * fs)
{
    for_each_transaction (fs, check_transaction);
}

