/* Copyright 2001, 2002, 2003 by Hans Reiser, licensing governed by reiser4/README */

/* Emergency flush */

#ifndef __EMERGENCY_FLUSH_H__
#define __EMERGENCY_FLUSH_H__


/* this bit is set when inode gets first eflushed jnode (eflush_add()). It is cleared when last eflushed jnode is
   eunflushed (eflush_del()). It solely exists to prevent inodes having eflushed jnodes from being pruned
   (fs/inode.c:can_unuse()) */
#define I_EFLUSH (256)

#include "block_alloc.h"

struct eflush_node;
typedef struct eflush_node eflush_node_t;

TYPE_SAFE_HASH_DECLARE(ef, eflush_node_t);

struct eflush_node {
	jnode           *node;
	reiser4_block_nr blocknr;
	ef_hash_link     linkage;
	struct list_head inode_link; /* for per inode list of eflush nodes */
	int              hadatom :1;
	int              incatom :1;
	int              reserve :1;
#if REISER4_DEBUG
	block_stage_t    initial_stage;
#endif
};

int eflush_init(void);
int eflush_done(void);

extern int  eflush_init_at(struct super_block *super);
extern void eflush_done_at(struct super_block *super);

extern reiser4_block_nr *eflush_get(const jnode *node);
extern void eflush_del(jnode *node, int page_locked);

int emergency_flush(struct page *page);
int emergency_unflush(jnode *node);


/* __EMERGENCY_FLUSH_H__ */
#endif

/* Make Linus happy.
   Local variables:
   c-indentation-style: "K&R"
   mode-name: "LC"
   c-basic-offset: 8
   tab-width: 8
   fill-column: 120
   End:
*/
