/*
 * Copyright (c) 1994, 1995, 1997
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code distributions
 * retain the above copyright notice and this paragraph in its entirety, (2)
 * distributions including binary code include the above copyright notice and
 * this paragraph in its entirety in the documentation or other materials
 * provided with the distribution, and (3) all advertising materials mentioning
 * features or use of this software display the following acknowledgement:
 * ``This product includes software developed by the University of California,
 * Lawrence Berkeley Laboratory and its contributors.'' Neither the name of
 * the University nor the names of its contributors may be used to endorse
 * or promote products derived from this software without specific prior
 * written permission.
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */
#ifndef lint
static const char rcsid[] =
    "@(#) $Header: utils.c,v 1.6 97/01/28 18:16:49 leres Exp $ (LBL)";
#endif

#include <sys/types.h>

#include <arpa/tftp.h>

#include <ctype.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>
#include <syslog.h>
#include <unistd.h>
#if __STDC__
#include <stdarg.h>
#else
#include <varargs.h>
#endif

#include "gnuc.h"
#ifdef HAVE_OS_PROTO_H
#include "os-proto.h"
#endif

#include "utils.h"

/*
 * Return true if this is a sun booting
 */
int
sunfile(file)
	char *file;
{
	register int n;
	register char *cp;

	/* We want to see 8 hex digits */
	cp = strrchr(file, '/');
	if (cp != NULL)
		++cp;
	else
		cp = file;
	for (n = 0; isxdigit(*cp); ++n)
		++cp;
	if (n != 8 || strncasecmp(cp, ".sun", 4) != 0)
		return (0);
	return (1);
}

/*
 * Return true if this is a fastpath booting
 */
int
fpfile(file)
	char *file;
{
	register int n;
	register char *cp;

	/* We want to see 8 hex digits */
	cp = strrchr(file, '/');
	if (cp != NULL)
		++cp;
	else
		cp = file;
	for (n = 0; isxdigit(*cp); ++n)
		++cp;
	if (n != 8 || strcasecmp(cp, ".conf") != 0)
		return (0);
	return (1);
}

void
#if __STDC__
log(int pri, char *fmt, ...)
#else
/*VARARGS1*/
log(pri, fmt, va_alist)
	int pri;
	char *fmt;
	va_dcl
#endif
{
	register char *cp;
	register char *cp2;
	va_list ap;
	char tfmt[BUFSIZ];

#if __STDC__
	va_start(ap, fmt);
#else
	va_start(ap);
#endif

	if (debug) {
		cp2 = fmt;
		cp = tfmt;
		while (*cp2 != '\0') {
			if (*cp2 == '%' && cp2[1] == '%') {
				*cp++ = *cp2++;
				*cp++ = *cp2++;
			} else if (*cp2 == '%' && cp2[1] == 'm') {
				cp2 += 2;
				(void)strcpy(cp, strerror(errno));
				cp += strlen(cp);
			} else
				*cp++ = *cp2++;
		}
		*cp = '\0';
		(void)vfprintf(stderr, tfmt, ap);
		(void)putc('\n', stderr);
	} else
		(void)vsyslog(pri, fmt, ap);
	va_end(ap);
}

