#include <varargs.h>

#include "config.h"
#include "menu.h"
#include "keymap.h"
#include "nn_term.h"
#include "options.h"
#include "proto.h"
#include "articles.h"
#include "stdio.h"


#ifdef TK
#include "tk.h"
#endif /* TK */
#include "tcltk.h"

#ifdef TK
static Tk_Window w; 			/* main window */
static Tcl_Interp *interp;     		/* tcl interpreter */
#endif /* TK */

extern char *getwd();

extern int curxy_c,curxy_l;
extern int prompt_line;
extern int prefetching;

extern int grp_menu();
extern int grp_list();
extern char *tk_set_var();
static int prompt_delete();
extern int rec_c();
static int folder_list();
static int more_lines();
static int option_values();
static int application_destroyed();
static int nn_variables();
static int nn_set_var();
static int nn_get_var();
static int nn_get_var_info();
static int lookup_group_pos();
static int do_subscribe();
static int end_subscribe();
static int do_group_cut();
static int do_group_paste();
static int nntp_abort();
extern int nn_var();
static int tk_toggle_select();
static int tk_recompile_kill();
static int tk_article_info();
static int tk_kill_prefetcher();
static int tk_abort_prefetcher();
static int is_prefetching();

extern char *nn_directory,*lib_directory,*help_directory;;
export int mk_grp_menu = 1;             /* create group menu */

export int tk_more_lines;		/* number of article lines to display
					   in one go */
export int tk_default_lines;		/* default number of article lines to display
					   in one go */
export int mime_handling;               /* action to take on articles with mime headers */
export int internal_editor;             /* flags internal editor as default */
export char xterm_path[100];            /* path to execute xterm */

export int group_list_read, group_list_unsub, group_list_all, group_list_width,
 group_menu_read,group_menu_unsub;      /* whats displayed in group list/menu */
export int nntp_progress,nntp_progress_a; /* report nntp progress every n lines */
export int article_select;		/* extended article number */
export int tk_debug = 0;		/* nn variable for debuging C/TK interface */
export int nntp_start = 0;		/* An nntp access has beem started */
export int group_menu_max = 0;		/* Entries to allocate for group menu */

#define BUFLEN 500
static char tkb[BUFLEN], *tkb_pt;		/* buffer for display using tk */
static char buf[BUFLEN];			/* misc buffer */
static int tk_np = 0;			/* flag distinguishes group or
					   article prompt from others  */
static int prompt_unmaped = 1;		/* flag prompt window not displayed */
import int nntp_abt;			/* flag to abort nntp reading */
#ifdef TK_IO
static Tcl_DString  tk_fgets_dstr;		/* static string used for tk_fgets return value */
#endif

#ifdef TK
int
xfile(txt)
char *txt;
{
        int code;

        code = Tcl_EvalFile(interp,txt);

        if (code != TCL_OK) {
		if (strncmp(".couldn't read file",interp->result,
		    strlen(".couldn't read file"))) {
                	printf("Error in file %s [%s]\n", txt, interp->result);
			printf("%s",tk_get_var("errorInfo"));
			exit(1);
		} else {
			return 0;
		}
        }
	return 1;
}

void
tk_init()
{
  char  lib[BUFLEN],nn[BUFLEN];
  char *x_dir, *x_file;
  FILE *f;
  char **argv;

  sprintf(lib,"%s/tcl/nn.tcl",lib_directory);
  sprintf(nn,"%s/tcl/nn.tcl",nn_directory);

  interp = Tcl_CreateInterp();

#if (((TK_MAJOR_VERSION == 4) && (TK_MINOR_VERSION > 0)) || (TK_MAJOR_VERSION > 4))
  tk_set_var("argv","-name nn");
  if (Tcl_Init(interp) == TCL_ERROR) {
    printf("%s\n", interp->result);
    exit;
  }
  if (Tk_Init(interp) == TCL_ERROR) {
    printf("%s\n", interp->result);
    exit;
  }
#else
  w = Tk_CreateMainWindow(interp,0,"nn","nn");

  if (w == NULL) {
    fprintf(stderr, "%s\n", interp->result);
    exit(1);
  }

  Tk_SetClass(w, "NN");
#endif

  tk_set_var("nn_directory",nn_directory);
  tk_set_var("help_directory",help_directory);

  Tcl_CreateCommand(interp,"option_values",option_values,NULL,NULL);
  Tcl_CreateCommand(interp,"grp_menu",grp_menu,NULL,NULL);
  Tcl_CreateCommand(interp,"nn_set_var",nn_set_var,NULL,NULL);
  Tcl_CreateCommand(interp,"nn_get_var",nn_get_var,NULL,NULL);

  if (f = fopen("./tcl/nn.tcl","r")) {
    x_dir = ".";
    x_file = "tcl/nn.tcl";
  } else if (f = fopen(nn,"r")) {
    x_dir = nn_directory;
    x_file = nn;
  } else if (f = fopen(lib,"r")) {
    x_dir = lib_directory;
    x_file = lib;
  } else {
    fprintf(stderr,"tcl directtory not found in ., %s, %s\n"
	    ,nn_directory,lib_directory);
    exit(1);
  } 
  fclose(f);

  tk_set_var("nn_x_dir",x_dir);

  xfile(x_file);
       

  Tcl_CreateCommand(interp,"nn_get_var_info",nn_get_var_info,NULL,NULL);
  Tcl_CreateCommand(interp,"prompt_delete",prompt_delete,NULL,NULL);
  Tcl_CreateCommand(interp,"grp_list",grp_list,NULL,NULL);
  Tcl_CreateCommand(interp,"rec_c",rec_c,NULL,NULL);
  Tcl_CreateCommand(interp,"folder_list",folder_list,NULL,NULL);
  Tcl_CreateCommand(interp,"more_lines",more_lines,NULL,NULL);
  Tcl_CreateCommand(interp,"application_destroyed",application_destroyed,NULL,NULL);
  Tcl_CreateCommand(interp,"nn_variables",nn_variables,NULL,NULL);
  Tcl_CreateCommand(interp,"lookup_group_pos",lookup_group_pos,NULL,NULL);
  Tcl_CreateCommand(interp,"subscribe",do_subscribe,NULL,NULL);
  Tcl_CreateCommand(interp,"end_subscribe",end_subscribe,NULL,NULL);
  Tcl_CreateCommand(interp,"group_cut",do_group_cut,NULL,NULL);
  Tcl_CreateCommand(interp,"group_paste",do_group_paste,NULL,NULL);
  Tcl_CreateCommand(interp,"nntp_abort",nntp_abort,NULL,NULL);
  Tcl_CreateCommand(interp,"toggle_select",tk_toggle_select,NULL,NULL);
  Tcl_CreateCommand(interp,"recompile_kill",tk_recompile_kill,NULL,NULL);
  Tcl_CreateCommand(interp,"article_info",tk_article_info,NULL,NULL);
  Tcl_CreateCommand(interp,"kill_prefetcher",tk_kill_prefetcher,NULL,NULL);
  Tcl_CreateCommand(interp,"abort_prefetcher",tk_abort_prefetcher,NULL,NULL);
  Tcl_CreateCommand(interp,"prefetching",is_prefetching,NULL,NULL);
#ifdef TK_IO  
  Tcl_DStringInit(&tk_fgets_dstr);
#endif
}

#endif /* TK */
/* read a tcl variable */
char *tk_get_var(var)
char *var; 
{
#ifdef TK
	char *s;

	s = Tcl_GetVar(interp,var,TCL_GLOBAL_ONLY|TCL_LEAVE_ERR_MSG);
	if (tk_debug) {
	  printf("%s=%s\n",var,s);	
	}
	if (!s) {
                printf("GetVar[%s]\n", interp->result);
        }
	return s;
#else /* TK */
	return 0;
#endif /* TK */
}

/* set a tcl variable */
char *tk_set_var(var,n)
char *var; char *n;
{
#ifdef TK
	char *s;
	if (tk_debug) {
	  printf("Set %s=%s\n",var,n);
	}
	s = Tcl_SetVar(interp,var,n,TCL_GLOBAL_ONLY);
	if (!s) {
                printf("SetVar[%s]\n", interp->result);
        }
	return s;
#else /* TK */
	return 0;
#endif /* TK */
}


/* Execute a tcl command */
char  
*tk(va_alist)
	va_dcl
{
#ifdef TK
  int code;
  va_list args;
  char *format;
  char bg[BUFLEN];

  va_start(args);
  format = va_arg(args,char *);
  vsprintf(bg,format,args);
  if (tk_debug) {
    fprintf(stderr,"<%s>\n",bg);
  }
  code = Tcl_Eval(interp,bg);

  if (code != TCL_OK) {
    printf(">%s[%s]\n", bg, interp->result);
    printf("%s",tk_get_var("errorInfo"));
    return NULL;
  } else {
/*    printf("%s\n",bg);	
    code = Tcl_Eval(interp,"update"); */
    return interp->result;
  }
#else  /* TK */
  return 0;
#endif /* TK */
}

/* return a result in a proc called from tcl */
int
tk_result(txt)
char *txt;
{
#ifdef TK
	strcpy(interp->result, txt);
	return TCL_OK;
#endif /* TK */
}

/* append a token to TCL result string */
void
tk_add_result(txt)
char *txt;
{
#ifdef TK
  Tcl_AppendResult(interp,txt," ",NULL);
#endif /* TK */
}

void  
y_prompt(va_alist)
	va_dcl
{
	va_list args;

	char *format;
	char b[BUFLEN];

	va_start(args);
	format = va_arg(args,char *);
	vsprintf(b,format,args);
#ifdef TK
	tk_set_var("prompt_buf",b);
	tk("y_prompt");
#else /* TK */
	prompt(b);
#endif /* TK */

}

/* bold header in article window */
void
tk_more_b(txt)
char *txt;
{
	sprintf(buf,"%s: ",txt);
	tk_set_var("more_l_t",buf);

	tk("more_b");
}

/* display text in article window */
void
tk_more_l(txt)
char *txt;
{
	sprintf(buf,"%s\n",txt);
	tk_set_var("more_l_t",buf);

	tk("more_l");
}

/* flag prompt as article or menu */
void tk_normal_prompt()
{
	tk_np = 1;
}

/* flag prompt as something else */
void tk_c_normal_prompt()
{
	tk_np = 0;
}

/* decide where to display prompt */
static char *pr_sel()
{
  int n;
  n = curxy_l - prompt_line;
  if (tk_np) {
    tk("info_reset");
    return ".menu-pr";
  }
  else if (n == 0) 
    return ".prompt.pr1";
  else if (n == 1)
    return ".prompt.pr2";
  else
    return ".prompt.pr3";

}	

/* prompt window has been deleted */
static int
prompt_delete() {
	prompt_unmaped = 1;
	return tk_result("1");
}

/* clear and remove prompt window */	
void 
prompt_clear() {
	if (tk_np) {
		tk("prompt_clear");
		prompt_unmaped = 1;
	}
}

/* clear line in prompt window */
void
tk_clrline() 
{
	if (prompt_unmaped && !tk_np) {
		tk("prompt_restore");
		prompt_unmaped = 0;
	}
	tk("prompt_clrline %s 1.%d",pr_sel(),curxy_c);
}

/* write text to prompt popup */
void
tk_txt_a(str)
char *str;
{
	if (prompt_unmaped && !tk_np) {
		tk("prompt_restore");
		prompt_unmaped = 0;
	}
	if (str[0] == '\r') {
		tk("prompt_clrline %s 1.0",pr_sel());
		str++;
	}
	tk("prompt_clrline %s 1.%d",pr_sel(),curxy_c);
	tk_set_var("text_ent_t",str);
	tk("text_add %s", pr_sel());
	tk("update");
}

/* write character to prompt popup */
void
tk_txt_c(c)
char c;
{
	char buff[BUFLEN];

	if (prompt_unmaped && !tk_np) {
		tk("prompt_restore");
		prompt_unmaped = 0;
	}
	if (c == '\b') {
	    tk("text_delc %s",pr_sel());
	} else if (c == '\r') {
		tk("prompt_clrline %s 1.0",pr_sel());
	} else {
	    buff[0] = c;
	    buff[1] = 0;
	    tk_set_var("text_ent_t",buff);
	    tk("text_add %s", pr_sel());
	}
/*	tk("update");*/
}

/* clear tkb buffer */
void
tkb_clear()
{
	tkb_pt = tkb;
}

/* put string to buffer (and call so_printf) */
void
tkb_so_printf(va_alist)
	va_dcl
{
        char *format;
	va_list args;

        va_start(args);
        format = va_arg(args,char *);
        vsprintf(tkb_pt,format,args);
        so_printf("%s",tkb_pt);
        tkb_pt += strlen(tkb_pt);
}

/* put string to buffer (and call ttprintf) */
void
tkb_tprintf(va_alist)
	va_dcl
{
        char *format;
	va_list args;

        va_start(args);
        format = va_arg(args,char *);
        vsprintf(tkb_pt,format,args);
        ttprintf("%s",tkb_pt);
        tkb_pt += strlen(tkb_pt);
}

/* put character to buff (and call ttputc) */
void
tkb_ttputc(c)
char c;
{
	*tkb_pt = c;
	tkb_pt++;
	*tkb_pt = 0;
	ttputc(c);
}

/* put character to buffer */
void
tkb_c(c)
char c;
{
	*tkb_pt = c;
	tkb_pt++;
	*tkb_pt = 0;
}

/* put string to buffer */
void
tkb_s(s)
char *s;
{
        sprintf(tkb_pt,"%s",s);
        tkb_pt += strlen(tkb_pt);
}

/* return current postion in buffer */
int
tkb_curr()
{
	return tkb_pt - tkb;
}

/* show buffer in display popup */
void
tkb_display()
{
	tk_set_var("display_l_t",tkb);

	tk("display_l");
	tkb_pt = tkb;
	*tkb_pt = 0;

}

/* show buffer in prompt */
void
tkb_txt_a()
{
	tk_txt_a(tkb);
	tkb_clear();
}

/* show buffer in group header */
void
tkb_menu_g()
{
	tk_set_var("text_ent_t",tkb);
	tk("menug_put");
}

/* sequentially fill  article menu */
void
tkb_menu_fill(l,c)
int l,c;
{
        strcat(tkb,"\n");
	tk_set_var("menu_ent_t",tkb);
        tk("menu_fill %d %d",l-1,c);
}

/* show buffer in article menu */
void
tkb_menu(l,c)
int l,c;
{
	tk_set_var("menu_ent_t",tkb);
        tk("menu_ent %d %d",l-1,c);
}

/* show buffer in article window */
void
tkb_more()
{
	tk_more_l(tkb);
}

void
tkb_bmore()
{
	tk_more_b(tkb);
}

/* show buffer as y/n prompt */
void
tkb_y_prompt()
{
	y_prompt(tkb);
}

static char read_mode[2];   /* flag indicating where get_c called from */

void
tk_read_mode(c)
char c;
{
  read_mode[0] = c;
  read_mode[1] = '\0';
  tk_set_var("read_mode",read_mode);
}

/* Indicate busy with nntp access */
tk_nntp_start(button)
int button;
{
  if (!nntp_start) {
    nntp_start = 1;
    if (button)
      tk("nntp_started");
    else
      tk("nntp_active_cursor");
  }
}

tk_nntp_fin()
{
  if (nntp_start) {
    nntp_start = 0;
    tk("nntp_inactive");
  }
}

#ifdef TK
/*
	Handle input
*/

extern int do_macro_processing;

typedef struct event_r event;

struct event_r {			/* record for input passed */
	int typ;			/* from tk 		   */
	int val;
	event *next_event;
};

static event *events,*cur_event;		/* event list, end pointer */
static event *n_event = 0;

  /* matches table in nn.tcl */
#define EV_CHAR	   	   '1'
#define EV_FUNCT	   '2'
#define EV_SELECT	   '3'
#define EV_SELECT_C        '4'
#define EV_RETURN	   '5'
#define EV_INT	   	   '6'
#define EV_SELECT_E        '7'
#define EV_SELECT_C_E      '8'

/* Called by tk when event to be passed */
int
rec_c (cl, interp, argc, argv)
ClientData cl;
Tcl_Interp *interp;
int argc;
char *argv[];
{
	if (!cur_event) {
		if (!events) {
			events = (event *) malloc(sizeof(event));
			events->next_event = 0;
		}
		cur_event = events;
	} else if (!cur_event->next_event) {
		cur_event->next_event = (event *) malloc(sizeof(event));
		cur_event->next_event->next_event = 0;
		cur_event = cur_event->next_event;
	} else
		cur_event = cur_event->next_event;
	cur_event->typ = *argv[1];
	if (cur_event->typ == EV_CHAR) 
	  cur_event->val = *argv[2];
	else
	  cur_event->val = atoi(argv[2]);

	/* fprintf(stderr,"n=%d t=%s v=%s\n",argc,argv[1],argv[2]);  */
	return tk_result("1");
}


/* Cancel a return to more mode */
int 
cancel_ret_c()
{
  if (n_event) {
    if (n_event->typ == '2' && n_event->val == 'K') {
      if (n_event == cur_event) {
	cur_event = 0;
	n_event = 0;
      } else 
	n_event = n_event->next_event;
    }
  }
}

/* input proc for nn code */
int
get_c()
{
  int v;
  static char s = ' ';
  int mc;

  if (do_macro_processing)
    switch (m_getc(&mc)) {
    case 0: break;
    case 1: return mc;
    case 2: return K_interrupt;
    }

  tk_nntp_fin();

  if (!n_event) {
    do {
      /* This goes back into tcl/tk */
      Tk_DoOneEvent(0); 
    } while (!cur_event);
    n_event = events;
  }
  s = n_event->typ;
  v = n_event->val;
  /*  fprintf(stderr,"s=%c v=%d %d\n",s,v,n_event == cur_event); */
  if (n_event == cur_event) {
    cur_event = 0;
    n_event = 0;
  } else 
    n_event = n_event->next_event;

  switch (s) {
  case EV_FUNCT:
    return (v + GETC_COMMAND);
    break;
  case EV_SELECT:
    return (v - 1 + K_ARTICLE_ID + GETC_COMMAND);
    break;
  case EV_SELECT_C:
    return (v - 1 + K_ARTICLE_ID_C + GETC_COMMAND);
    break;
  case EV_INT:
    if (*read_mode == ' ') {
      return (K_interrupt);
    } else {
      return(get_c());
    }
    break;
  case EV_SELECT_E:
    article_select = v - 1;
    return (K_ARTICLE_EXT + K_ARTICLE_ID + GETC_COMMAND);
    break;
  case EV_SELECT_C_E:
    article_select = v - 1;
    return (K_ARTICLE_EXT + K_ARTICLE_ID_C + GETC_COMMAND);
    break;
  case EV_CHAR:
    return global_key_map[v];
    break;
  default:
    printf("Shouldn't be here\n");
  }
}

/* folder list */
static int
folder_list() {
	char tmp[100];

	tmp[0] = '+'; tmp[1] = 0;
	file_completion(tmp,1);
	compl_folder_directory();
	close_directory();
	return tk_result("1");
}

static int
more_lines(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
	tk_more_lines = atoi(argv[1]);
	return tk_result("1");
}

static int
is_prefetching(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
#ifdef NNTP
  if (prefetching)
    return tk_result("1");
  else
#endif
    return tk_result("0");
}

static int
lookup_group_pos(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    group_header *gh;
    char buf[100];

    gh = lookup(argv[1]);
    if (gh) {
	sprintf(buf,"%d",gh->listbox_entry);
	return tk_result(buf);
    } else {
	return tk_result("0");
    }
}

/* 
finish unsubscribe - update .newsrc
*/
static int
end_subscribe(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  do_rc_update();	
}

/*
  subscribe or unsubscribe to a group
*/
static int
do_subscribe(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    group_header *gh;

    gh = lookup(argv[1]);
    if (gh) {
	if (argv[2][0] == 's') {
	    add_to_newsrc(gh);
	    re_subscribe(gh);
	} else if (argv[2][0] == 'o') {
	    gh->group_flag &= ~G_NEW;
	    both_rc_update(gh);
	} else {
	    gh->group_flag &= ~G_NEW;
	    gh->group_flag |= G_UNSUBSCRIBED;
	    both_rc_update(gh);
	}
    }
    return tk_result("0");
}

/*cut groups out of sequence chain */
static int
do_group_cut(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    group_cut(argv[1],argv[2]);
    return tk_result("1");
}

/*paste groups back into sequence chain*/
static int
do_group_paste(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
    group_paste(argv[1],argv[2][0]);
    grp_listbox_reset();
    return tk_result("1");
}

/* set abort flag for nntp reading */
static int
nntp_abort(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
#ifdef NNTP
  if (prefetching) 
    kill_prefetcher();
  else
#endif
    nntp_abt = 1;

  return tk_result("1");
}

/* set C variables corresponding to nn-tk
   option values */
static int
option_values(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
	mk_grp_menu = atoi(argv[1]);
	tk_more_lines = tk_default_lines = atoi(argv[2]);
	mime_handling = atoi(argv[3]);
	strncpy(xterm_path,argv[4],100);
	group_list_read = atoi(argv[5]);
	group_list_unsub = atoi(argv[6]);
	group_list_all = atoi(argv[7]);
	group_list_width = atoi(argv[8]);
	group_menu_read  = atoi(argv[9]);
	group_menu_unsub = atoi(argv[10]);
	nntp_progress = atoi(argv[11]);
	nntp_progress_a = atoi(argv[12]);
	group_menu_max = atoi(argv[13]);
	return tk_result("1");
}

static int
nn_variables(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  char x;
  char *window;

  x = argv[1][0];
  nn_var_list(x);
  return TCL_OK;
}

static int
nn_set_var(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  char *variable, *value;

  variable = argv[1];
  value = argv[2];
  set_variable(variable,1,value);
  return tk_result("1");
}


static int
nn_get_var(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  return nn_var_val(argv[1]);
}

static int
nn_get_var_info(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  return nn_var_info(argv[1]);
}

static int
tk_toggle_select(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  toggle_select(atoi(argv[1]));
  return tk_result("1");
}

static int
tk_recompile_kill(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  reinit_kill();
  return tk_result("1");
}

static int
tk_kill_prefetcher(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
#ifdef NNTP
  kill_prefetcher();
#endif
  return tk_result("1");
}

static int
tk_abort_prefetcher(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
#ifdef NNTP
  abort_prefetcher();
#endif
  return tk_result("1");
}

static int
tk_article_info(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
  char *subj, *send, *from, *group, *msgid;

  article_info(&subj, &send, &from, &group, &msgid);
  if (subj)
    tk_set_var("ksel_subj",subj);
  else		
    tk_set_var("ksel_subj","");
  if (send)
    tk_set_var("ksel_send",send);
  else		
    tk_set_var("ksel_send","");
  if (from)
    tk_set_var("ksel_from",from);
  else		
    tk_set_var("ksel_from","");
  if (msgid)
    tk_set_var("ksel_msgid",msgid);
  else		
    tk_set_var("ksel_msgid","");
  if (group)
    tk_set_var("ksel_group",group);
  else		
    tk_set_var("ksel_group","");
  return tk_result("1");
}

/* pass an NN variables value and tag info to TCL */
void
tk_nn_var(str,type,tag)
char  *str, *type, *tag;
{
  char *tg;

  if (*tag == '*') {
    tg = "m";
  } else if (*tag == '=') {
    tg = "t";
  } else if (*tag == '>') {
    tg = "p";
  } else {
    tg = "u";
  }
  tk_set_var("var_str",str);
  tk_set_var("var_type",type);
  tk_set_var("var_tg",tg);
}

static int
application_destroyed(clientData,interp,argc,argv)
ClientData clientData;
Tcl_Interp *interp;
int argc;
char *argv[];
{
/*  nn_exitmsg(1, "NN terminated, X application destroyed");*/
  nn_exit(0);
}


/*
	process newsgroup list to produce
	cascaded group menus
*/

typedef struct  {
	char *t;
	int l;
} gx_t;

#define GX_L 50
gx_t group_x[GX_L];

static char prev_group[300] = "";

#define SG_L BUFLEN
static char split_group[SG_L];

void grp_setup()
{
  char *s, *w ;
  int i;

  s = tk_get_var("split_group");
  strncpy(split_group,s,SG_L);
  w = strtok(split_group,",");
  i = 0;
  while (w != NULL && i < GX_L) {
    if (*w == '_') {
      *w = 0;
    }
    group_x[i].t = w;
    group_x[i].l = strlen(w);
    i++;
    w = strtok(NULL,",");
  }
  group_x[i].t = NULL;
}

static char
*lcase(txt)
char *txt;
{
    static char x[200];
    char *p;
    
    strncpy(x,txt,200);
    for (p = x; *p; p++) {
	if (*p >= 'A' && *p <= 'Z') {
	    *p += 32;
	}
    }
    return x;
}

static void
group(g)
char *g;
{
  char left[300];
  char *right, *tmp, *cbreak;
  int l;

  right = strrchr(g,'.');
  if (right) {
    l = right - g;
    strncpy(left,g,l);
    left[l] = 0;
    if (strncmp(g,prev_group,l) || (prev_group[l] != '.')) {
      group(left);
    }
  } else {
    *left = '\0';
  }

  tk("menu .top.m.menu.%s",lcase(g));
  if (*left) {
    cbreak = "";
#if (TK_MAJOR_VERSION >= 8)
    tk("break_menu .top.m.menu.%s",lcase(left));
    tmp = tk_get_var("menu_break");
    if (tmp[0] == '1') {
      cbreak = " -columnbreak 1";
    }
#endif    
    tk(".top.m.menu.%s add cascade -label \"%s->\" -menu \".top.m.menu.%s\" %s",lcase(left),right+1,g,cbreak);
  } else {
    tk(".top.m.menu add cascade -label \"%s->\" -menu \".top.m.menu.%s\"",g,lcase(g));
  }

}

void
grp(g)
char *g;
{
  char b1[300],b2[300],left[300];
  char *b,*c,*t,*right, *tmp, *cbreak;
  gx_t *gx = group_x;
  int l;


  /* match starts of group names against gx list,
     expanding with first letter of next token */
  strcpy(b1,g);
  b=b1;
  c=b2;
  while (gx->t) {
    l = gx->l;
    if (!strncmp(gx->t,b,l)) {
      strncpy(c,b,l+1);
      c[l+1] = '.';
      strcpy(c+l+2,b+l);
      t = b; b = c; c = t;
    }
    gx++;
  }

  /* split off right most token comparing the rest
     against the previous group, recursing to create
     menu's not matching */
  right = strrchr(b,'.');
  if (right) {
    l = right - b;
    strncpy(left,b,l);
    left[l] = 0;
    if (strncmp(left,prev_group,l) || (prev_group[l] != '.')) {
      group(left);
    }
    right = right+1;
    if (! *right) { /* a null string for right causes problem */
      right = "_";
    }

    cbreak = "";
#if (TK_MAJOR_VERSION >= 8)
    tk("break_menu .top.m.menu.%s",lcase(left));
    tmp = tk_get_var("menu_break");
    if (tmp[0] == '1') {
      cbreak = " -columnbreak 1";
    }
#endif    
    tk(".top.m.menu.%s add command -label %s -command \"gg %s %s\" %s",lcase(left),right,g,lcase(left),cbreak);
  } else {
    tk(".top.m.menu add command -label %s -command \"gg %s\"",g,lcase(g));
  }

  strcpy(prev_group,b);
}
#endif /* TK */

void
tk_group_ent(gh,command)
group_header *gh;
char *command;
{
#ifdef TK
    int extra;
    char *xtab;

    if ((gh->group_flag & G_UNKNOWN)) {
      if ((gh->group_flag & G_RDAHEAD)) {
	tk("%s \"%s\t.\" %d",
	   command, gh->group_name,gh->listbox_entry);
      } else {
	tk("%s \"%s\t\" %d",
	   command, gh->group_name,gh->listbox_entry);
      }
    } else {
	if (group_list_all &&
	    (gh->unread_count != (gh->last_a_article - gh->first_a_article + 1))) {
	  extra = 1;
	} else 
	  extra = 0;

	if (group_list_all) {
	  xtab = "\t";
	} else {
	  xtab = "";
	}

	if (extra) {
	    tk("%s  \"%s\t%d\t(%d)\" %d",
	       command, gh->group_name,
	       gh->unread_count,
	       (gh->last_a_article - gh->first_a_article +1),
	       gh->listbox_entry);
	} else if (gh->group_flag & G_UNSUBSCRIBED) {
	    tk("%s \"%s\t%d%s\" %d",
	       command, gh->group_name,
	       (gh->last_a_article - gh->first_a_article +1),
	       xtab, gh->listbox_entry);
	} else {
	    tk("%s \"%s\t%d%s\" %d",
	       command, gh->group_name,
	       gh->unread_count,
	       xtab,gh->listbox_entry);
	}
    }
    if ((gh->group_flag & G_NEW)) {
	tk("list_flag n %d %d",gh->group_flag & G_RC,gh->listbox_entry);
    } else if ((gh->group_flag & G_UNSUBSCRIBED)) {
	tk("list_flag u %d %d",gh->group_flag & G_RC,gh->listbox_entry);
    } else {
	tk("list_flag x %d %d",gh->group_flag & G_RC,gh->listbox_entry);
    }
#endif /*TK*/
}

#ifdef TK_IO
/*
NOTE: if TK_IO is defines the FILE * paramters used by these
      routines ace really Tcl_Channel types
*/

static int tk_fgets_input;	/* this is a temporary used between routines */

void  tk_fgets_proc(clientData, mask)
ClientData clientData; int mask;
{
 Tcl_Channel chn;
 int n;

 chn = (Tcl_Channel)clientData;

 Tcl_DeleteChannelHandler(chn,
                       tk_fgets_proc, (ClientData)chn);
  tk_fgets_input = 1;
}

#endif

FILE *tk_fdopen(fd, mode)
 int fd; char *mode;
{
#ifndef TK_IO  
  return fdopen(fd, mode);
#else
  Tcl_Channel chn;
  int n;

#if (TK_MAJOR_VERSION >= 8)
  chn = Tcl_MakeFileChannel((ClientData)fd,TCL_READABLE|TCL_EXCEPTION);
#else
  chn = Tcl_MakeFileChannel((ClientData)fd,0,TCL_READABLE|TCL_EXCEPTION);
#endif
  Tcl_RegisterChannel(interp, chn);
  if (*interp->result) 
    printf("Tcl_RegisterChannel=%s\n",interp->result);
  n = Tcl_SetChannelOption(interp, chn, "-blocking","0");
  if (n != TCL_OK) 
    printf("Tcl_SetChannelOption=%s\n",interp->result);

  return (FILE *)chn;
#endif
}

int tk_fclose(file)
 FILE *file;
{
#ifndef TK_IO  
  return fclose(file);
#else
  int n;

  n = Tcl_UnregisterChannel(interp, (Tcl_Channel)file);
  if (n != TCL_OK) 
    printf("Tcl_UnregisterChannel=%s\n",interp->result);
  return 1;
#endif
}  

/* reads on this file are done thru the Tk main loop
   so the interface is still active
*/


char *
tk_fgets(str, size, file)
char *str;
int size;
FILE *file;
{
#ifndef TK_IO

  if (str) {
    return fgets(str, size, file);
  } else {
    return fgetstr(file);
  }

#else

  Tcl_Channel chn;
  char *r;
  int n, y;

  chn = (Tcl_Channel)file;
  Tcl_DStringSetLength(&tk_fgets_dstr,0);

  if ((n = Tcl_Gets(chn, &tk_fgets_dstr)) >= 0) {
    if (str) {
      strncpy(str,tk_fgets_dstr.string,size);
      return str;
    } else
      return tk_fgets_dstr.string;
  } else {
    if (!Tcl_InputBlocked(chn)) {
      printf("BL1\n");
      return NULL;
    }

again:
    Tcl_CreateChannelHandler(chn,
                         TCL_READABLE|TCL_EXCEPTION,
                         tk_fgets_proc, (ClientData)chn);
    tk_fgets_input = 0;
    do {
      n=Tk_DoOneEvent(0); 
    } while (!tk_fgets_input && !Tcl_Eof(chn));


    Tcl_DStringSetLength(&tk_fgets_dstr,0);
    n = Tcl_Gets(chn, &tk_fgets_dstr);
    if (n >= 0) {
      if (str) {
	strncpy(str,tk_fgets_dstr.string,size);
	return str;
      } else {
	return tk_fgets_dstr.string;
      }
    } else {
      printf(".",n);
      if (!Tcl_InputBlocked(chn)) {
	printf("BL2\n");
	return NULL;
      } else
	goto again;
    }
  }
#endif
}
