##################################################################
#
# GUI interface to kill/select
#  rewrites the kill file
#
##################################################################

proc killsel_setup {{item ""}} {
    global ksel

    article_info
    global ksel_group ksel_subj ksel_send ksel_from ksel_msgid nn_directory

    killsel_Make
    update

    if {[file readable "$nn_directory/kill"]} {
	set f [open "$nn_directory/kill" r]
	while {[gets $f l] > 0} {
	    .killsel.lb.l insert end $l
	}
	close $f
    }
    
    if {$item != ""} {
	killsel_list_add

	ksel_parse_item $item

	set ksel(group) $ksel_group
	
	switch $ksel(type,0) {
	    "n"
	      {set ksel(strings,0) $ksel_send}
	    "s"
	      {set ksel(strings,0) $ksel_subj}
	    "f"
	      {set ksel(strings,0) $ksel_from}
	    "m"
	      {set ksel(strings,0) $ksel_msgid}
	}
    }
}

proc killsel_exit {save} {
    global token  

    if {$save == 1} {
	killsel_writefile
	recompile_kill
	put_funct $token(K_KILLSEL) "b"
    }
    ksel_window destroy .killsel
    ksel_window destroy .ksel
}

proc killsel_writefile {} {
    global ksel nn_directory

    if {$ksel(listbox) >= 0} {
	ksel_out_item $ksel(listbox)
    }

    set f [open "$nn_directory/kill" w]

    set size [.killsel.lb.l size]
    for {set i 0} {$i < $size} {incr i} {
	puts $f [.killsel.lb.l get $i]
    }
    close $f
}

proc killsel_Make {} {
    global ksel Config

    set ksel(listbox) -1

    set base .killsel
    if {[winfo exists .killsel]} {
        wm deiconify .killsel; return
    }

    toplevel .killsel -class Toplevel 

    wm deiconify .killsel
    wm title .killsel "killsel"
    label .killsel.l \
        -relief raised -text "Kill or Select"

    frame .killsel.buttons \
         -borderwidth 1 -height 30 -relief sunken -width 30 
    button .killsel.buttons.add \
        -padx 0 -pady 0 -text Add -width 6 \
	-command {killsel_list_add}

    button .killsel.buttons.del \
        -padx 0 -pady 0 -text Delete -width 6 \
	-command {killsel_list_delete}

    button .killsel.buttons.help \
        -padx 0 -pady 0 -text Help -width 6 \
	-command "put_extended {help nn-tk-kill}"
    button .killsel.buttons.cancel \
        -padx 0 -pady 0 -text Cancel -width 6 \
	-command {killsel_exit 0}
    button .killsel.buttons.save \
        -padx 0 -pady 0 -text Save -width 6 \
	-command {killsel_exit 1}
    frame .killsel.buttons.dummy \
	-width 16
    frame .killsel.lb \
         -borderwidth 1 -height 30 -relief raised -width 30 
    listbox .killsel.lb.l \
        -xscrollcommand {.killsel.lb.02 set} \
        -yscrollcommand {.killsel.lb.03 set} 

    scrollbar .killsel.lb.02 \
        -borderwidth 1 -command {.killsel.lb.l xview} \
        -orient horiz -width 10 
    scrollbar .killsel.lb.03 \
        -borderwidth 1 -command {.killsel.lb.l yview} \
        -orient vert -width 10 
    ###################
    # SETTING GEOMETRY
    ###################
    pack .killsel.l \
        -anchor center -expand 0 -fill x -side top 
    pack .killsel.buttons \
        -anchor center -expand 0 -fill x -side top 
    pack .killsel.buttons.add \
        -anchor nw -expand 0 -fill none -side left 
    pack .killsel.buttons.del \
        -anchor nw -expand 0 -fill none -side left 
    pack .killsel.buttons.cancel \
        -anchor nw -expand 0 -fill none -side right
    pack .killsel.buttons.save \
        -anchor nw -expand 0 -fill none -side right
    pack .killsel.buttons.help \
        -anchor w -expand 0 -fill none -side right
    pack .killsel.buttons.dummy \
        -anchor w -expand 0 -fill none -side right
    
    pack .killsel.lb \
        -anchor center -expand 1 -fill both -side top 
    grid columnconf .killsel.lb 0 -weight 1
    grid rowconf .killsel.lb 0 -weight 1
    grid .killsel.lb.l \
        -column 0 -row 0 -columnspan 1 -rowspan 1 -sticky nesw 
    grid .killsel.lb.02 \
        -column 0 -row 1 -columnspan 1 -rowspan 1 -sticky ew 
    grid .killsel.lb.03 \
        -column 1 -row 0 -columnspan 1 -rowspan 1 -sticky ns 

    bind .killsel.lb.l  <ButtonRelease-1> {ksel_press %y }
    
    balloonHelp_traverse  .killsel

    if {[info exists Config(.killsel)]} {
	wm geometry  .killsel $Config(.killsel)
    }

}

proc ksel_press {y} {
    global ksel 

    set old $ksel(listbox)

    scan [.killsel.lb.l index @0,$y] %d n
    set l [.killsel.lb.l get $n]
    set ksel(listbox) $n

    if {$old >= 0} {
	ksel_out_item $old
    }

    ksel_parse_item $l
}

proc killsel_list_delete {} {
    global ksel

    if {$ksel(listbox) >= 0} {
	.killsel.lb.l delete $ksel(listbox)
	set ksel(listbox) -1
	ksel_window hide .ksel
    } elseif {$ksel(clistbox) >= 0} {
	.killsel.lb.l delete $ksel(clistbox)
	set ksel(clistbox) -1
	ksel_window hide .ksel
    }
}
    
proc killsel_list_add {} {
    global ksel

    if {$ksel(listbox) >= 0} {
	ksel_out_item $ksel(listbox)
    }

    if {$ksel(listbox) >= 0} {
	.killsel.lb.l insert [expr $ksel(listbox)+1] ""
	set ksel(listbox) [expr $ksel(listbox)+1]
    } else {
	.killsel.lb.l insert end ""
	set ksel(listbox) [.killsel.lb.l size]
    }
    ksel_parse_item "::"
}

proc ksel_setlabel {but lab {var ""} {chr ""}} {
    global ksel

    $but configure -text $lab
    if {$var != ""} {
	set ksel($var) $chr
    }
}

proc ksel_item_subst {l} {
    regsub -all {\\\\} $l "\01" t
    regsub -all {\\:} $t "\02" t
    return $t
}

proc ksel_item_substs {l} {
    regsub -all "\01" $l "\\" t
    regsub -all "\02" $t ":" t
    return $t
}

proc ksel_item_substd {l} {
    regsub -all {\\} $l {\\\\} t
    regsub -all {:} $t {\\:} t
    return $t
}

proc ksel_parse_group {l} {
    global ksel

    regexp {(/*)(.*)} $l d ksel(gregexp) ksel(group)
}

proc ksel_parse_flags {l} {
    global ksel

    set ksel(knotsel)  ""
    if ([regexp {(.*)(\~)(.*)} $l d ls ksel(knotsel) lf]) {
	set l "$ls$lf"
    }

    set ksel(action) ""
    if ([regexp {(.*)([\+\!])(.*)} $l d ls ksel(action) lf]) {
	set l "$ls$lf"
    }

    set ksel(followups) ""
    if ([regexp {(.*)([\>\<])(.*)} $l d ls ksel(followups) lf]) {
	set l "$ls$lf"
    }

    set l "&$l"
    set i 0
    while {[regexp {^([\&\|])([^\&\|]*)(.*)} $l d joiner str rest] != 0}  {
	ksel_parse_elem $i $joiner $str
	set l $rest
	incr i
    }
}
	
proc ksel_parse_elem {n joiner l} {
    global ksel

    set ksel(type,$n) ""
    if ([regexp {(.*)([nsfcClLam])(.*)} $l d ls ksel(type,$n) lf]) {
	set l "$ls$lf"
    }

    set ksel(regexp,$n) ""
    if ([regexp {(.*)([/])(.*)} $l d ls ksel(regexp,$n) lf]) {
	set l "$ls$lf"
    }

    set ksel(case,$n) ""
    if ([regexp {(.*)([=])(.*)} $l d ls ksel(case,$n) lf]) {
	set l "$ls$lf"
    }

    set ksel(join,$n) $joiner
    
}
    
proc ksel_parse_item {ent} {
    global ksel

    if {[string index $ent 0] == "\#"} {
	set ksel(clistbox) $ksel(listbox)
	set ksel(listbox) -1
	return
    } else {
	set ksel(clistbox) -1
	if {![winfo exists .ksel]} {
	  ksel_Make
	}
	if {![winfo ismapped .ksel]} {
	  ksel_window unhide .ksel
	}
	set ent [ksel_item_subst $ent]
	set lent [split $ent ":"]
	set  ctime [lindex $lent 0]
	set ksel(expire) ""
	if {[regexp {^[0123456789]+$} $ctime d]} {
	    if {$ctime < 1000} {
		set ksel(expire) $ctime
	    } else {
		set ksel(expire) [expr (($ctime-[clock seconds])/86400)+1]
	    }
	    set lent [lrange $lent 1 end]
	}
	ksel_parse_group [lindex $lent 0]
	ksel_parse_flags [lindex $lent 1]
	set i 0
	foreach s [lrange $lent 2 end] {
	    set ksel(strings,$i) $s
	    set ksel(count) $i
	    incr i
	}
	ksel_set_panel
    }
}

proc ksel_out_item {pos} {
    global ksel

    if {$ksel(type,0) == ""} {
	 killsel_list_delete
	return
    }
	
    set etxt $ksel(expire)
    if {$etxt != ""} {
	set etxt [expr $etxt*86400+[clock seconds]]
	set etxt "$etxt:"
    }

    set group "$ksel(gregexp)$ksel(group):"

    set mflag "$ksel(knotsel)$ksel(action)$ksel(followups)"

    set flags ""
    set strings ""
    set slaves [pack slaves .ksel]
    foreach w $slaves {
	if {[regexp  {\.ksel\.m([0123456789]+)} $w d n]} {
	    if {$ksel(type,$n) != ""} {
		if {$n != 0} {
		    set flags "$flags$ksel(join,$n)"
		}
		set flags "$flags$ksel(type,$n)$ksel(regexp,$n)$ksel(case,$n)"
		set s [ksel_item_substd $ksel(strings,$n)]
		set strings "$strings:$s"
	    }
	}
    }

    .killsel.lb.l delete $pos
    .killsel.lb.l insert $pos "$etxt$group$mflag$flags$strings"
}

proc ksel_set_panel {} {
    global ksel
    
    switch $ksel(action) {
	""
	  {ksel_setlabel .ksel.fix.f.action NONE }
	"+"
	  {ksel_setlabel .ksel.fix.f.action auto-select }
	"!"
	  {ksel_setlabel .ksel.fix.f.action auto-kill }
    }

    switch $ksel(followups) {
	""
	  {ksel_setlabel .ksel.fix.fr.f.follow "all" }
	"+"
	  {ksel_setlabel .ksel.fix.fr.f.follow "only followups" }
	"!"
	  {ksel_setlabel .ksel.fix.fr.f.follow "only base articles" }
    }

    for {set i 0} {$i <= $ksel(count)} {incr i} {
	if {![winfo exists .ksel.m$i]}  {
	    ksel_frame_elem $i [expr $i-1]
	}
	ksel_set_elem $i
    }
    for {set i [expr $ksel(count)+1]} {$i <= 25} {incr i} {
	if {[winfo exists .ksel.m$i]}  {
	    ksel_destroy_elem .ksel.m$i $i
	}
    }
}

proc ksel_destroy_elem {w n} {
    global ksel

    destroy $w
    set ksel(strings,$n) ""
    set ksel(regexp,$n) ""
    set ksel(case,$n) ""
}

proc ksel_set_elem_type {n} {
    global ksel

    switch $ksel(type,$n) {
	""
	{ksel_setlabel .ksel.m$n.i.type TYPE }
	"n"
	{ksel_setlabel .ksel.m$n.i.type name }
	"s"
	{ksel_setlabel .ksel.m$n.i.type subject }
	"f"
	{ksel_setlabel .ksel.m$n.i.type from type }
	"m"
	{ksel_setlabel .ksel.m$n.i.type message-id }
	"c"
	{ksel_setlabel .ksel.m$n.i.type <crossposts }
	"C"
	{ksel_setlabel .ksel.m$n.i.type >crossposts }
	"l"
	{ksel_setlabel .ksel.m$n.i.type <lines type }
	"L"
	{ksel_setlabel .ksel.m$n.i.type >lines type }
	"a"
	{ksel_setlabel .ksel.m$n.i.type ignore type }
    }
}

proc ksel_set_elem {n} {
    global ksel k_regexp k_case

    switch $ksel(join,$n) {
	"|"
	  {ksel_setlabel .ksel.m$n.i.con OR }
	"&"
	  {ksel_setlabel .ksel.m$n.i.con AND }
    }

    set ksel(strings,$n) [ksel_item_substs $ksel(strings,$n)]

    ksel_set_elem_type 0

    if {$ksel(regexp,$n) != ""} {
	set k_regexp($n) 1
    } else {
	set k_regexp($n) 0
    }
    if {$ksel(case,$n) != ""} {
	set k_case($n) 1
    } else {
	set k_case($n) 0
    }
}

proc ksel_Make {args} {
    global ksel

    set base .ksel
    if {[winfo exists .ksel]} {
        wm deiconify .ksel; return
    }
    ###################
    # CREATING WIDGETS
    ###################
    toplevel .ksel -class Toplevel 
    bind .ksel <Destroy> ksel_destroyed
    wm deiconify .ksel
    wm title .ksel "ksel"

    set rx [expr [winfo rootx .killsel]+[winfo width .killsel]+10]
    set ry [winfo rooty .killsel]
    wm geometry .ksel "+$rx+$ry"

    label .ksel.l \
        -relief raised -text {Kill or Select Item} 
    frame .ksel.fix \
        -borderwidth 2 -height 30 -relief raised -width 30 
    frame .ksel.fix.f \
        -borderwidth 1 -height 30 -relief sunken -width 30 

    menubutton .ksel.fix.f.action \
        -indicatoron 1 -menu .ksel.fix.f.action.m -padx 10 -pady 3 \
        -relief raised 
    menu .ksel.fix.f.action.m -tearoff 0
    .ksel.fix.f.action.m add command -label NONE \
	-command "ksel_setlabel .ksel.fix.f.action NONE action \"\""
    .ksel.fix.f.action.m add command -label auto-select \
	-command "ksel_setlabel .ksel.fix.f.action auto-select action +" 
    .ksel.fix.f.action.m add command -label auto-kill \
	-command "ksel_setlabel .ksel.fix.f.action auto-kill action !" 

    frame .ksel.fix.f.m \
        -borderwidth 1 -height 30 -relief raised -width 30 
    label .ksel.fix.f.m.l \
        -anchor w -text Group 
    entry .ksel.fix.f.m.group \
        -textvariable ksel(group)

    checkbutton .ksel.fix.f.reg \
        -relief raised -text {Regular Expression} -variable ksel(gregexp) \
	-onvalue "/" -offvalue ""
    frame .ksel.fix.fr \
        -borderwidth 1 -height 30 -relief sunken -width 30
 
    frame .ksel.fix.fr.f \
         -borderwidth 1 -height 30 -relief sunken -width 30 
    menubutton .ksel.fix.fr.f.follow \
        -indicatoron 1 -menu .ksel.fix.fr.f.follow.m \
        -relief raised -width 24
    menu .ksel.fix.fr.f.follow.m -tearoff 0
    .ksel.fix.fr.f.follow.m add command -label all \
	-command "ksel_setlabel .ksel.fix.fr.f.follow {all} followups \"\""
    .ksel.fix.fr.f.follow.m add command -label {only followups} \
	-command "ksel_setlabel .ksel.fix.fr.f.follow {only followup} followups >" 
    .ksel.fix.fr.f.follow.m add command -label  {only base articles}\
	-command "ksel_setlabel .ksel.fix.fr.f.follow {only base article} followups <" 
    checkbutton .ksel.fix.fr.f.knotsel \
        -anchor w \
        -padx 4 -relief raised \
        -text {Kill articles not selected} -variable ksel(notsel) \
	-onvalue "-" -offvalue "" -width 28
    frame .ksel.fix.fr.f.e
    label .ksel.fix.fr.f.e.l  -text "expire(days)"
    entry .ksel.fix.fr.f.e.ent -textvariable ksel(expire)
    ###################
    # SETTING GEOMETRY
    ###################
    pack .ksel.l \
        -anchor center -expand 0 -fill x -side top 
    pack .ksel.fix \
        -anchor center -expand 0 -fill both -side top 
    pack .ksel.fix.f \
        -anchor center -expand 0 -fill both -side top 
    pack .ksel.fix.f.action \
        -anchor center -expand 0 -fill none -pady 4 -side top 
    pack .ksel.fix.f.m \
        -anchor center -expand 0 -fill x -side top 
    pack .ksel.fix.f.m.l \
        -anchor center -expand 0 -fill none -padx 2 -pady 2 -side left 
    pack .ksel.fix.f.m.group \
        -anchor center -expand 1 -fill x -padx 2 -pady 2 -side right 
    pack .ksel.fix.f.reg \
        -anchor w -expand 0 -fill none -side top 
    pack .ksel.fix.fr \
        -anchor center -expand 0 -fill both -side top 
    pack .ksel.fix.fr.f \
        -anchor center -expand 0 -fill none -side top 
    pack .ksel.fix.fr.f.follow \
        -anchor w -expand 0  -side top
    pack .ksel.fix.fr.f.knotsel \
        -anchor w -expand 0  -side top
    pack .ksel.fix.fr.f.e \
        -anchor w -expand 0  -side top
    pack .ksel.fix.fr.f.e.l \
	-anchor w -side left
    pack .ksel.fix.fr.f.e.ent \
	-anchor w -side right
}

proc ksel_elem_empty {} {
    for {set i 0} {$i <= 25} {incr i} {
	if {![winfo exists .ksel.m$i]}  {
	    return $i
	}
    }
    return $i
}

proc ksel_elem_new {m l j} {
    global ksel

    set n [ksel_elem_empty]
    ksel_frame_elem  $n $m
    set ksel(type,$n) ""
    ksel_setlabel .ksel.m$n.i.con $l join,$n $j
}

proc ksel_frame_elem {n m} {
    global ksel

    frame .ksel.m$n \
        -borderwidth 1 -height 184 -relief sunken \
        -width 30 
    frame .ksel.m$n.i \
        -borderwidth 1 -height 30 -relief sunken -width 30 

    menubutton .ksel.m$n.i.con \
        -indicatoron 1 -menu .ksel.m$n.i.con.m -padx 4 -pady 1 \
	-relief raised -text conn 
    menu .ksel.m$n.i.con.m  -tearoff 0
     .ksel.m$n.i.con.m add command -label OR \
	-command "ksel_setlabel .ksel.m$n.i.con OR join,$n |"
    .ksel.m$n.i.con.m add command -label AND \
	-command "ksel_setlabel .ksel.m$n.i.con AND join,$n &" 

    entry .ksel.m$n.i.str \
        -textvariable ksel(strings,$n) -width 32
    menubutton .ksel.m$n.i.type \
        -indicatoron 1 -menu .ksel.m$n.i.type.m -padx 2 -pady 1 \
        -relief raised -text TYPE
    menu .ksel.m$n.i.type.m  -tearoff 0
    .ksel.m$n.i.type.m add command -label name\
    -command "ksel_setlabel .ksel.m$n.i.type name type,$n n"
    .ksel.m$n.i.type.m add command -label subject\
    -command "ksel_setlabel .ksel.m$n.i.type subject type,$n s"
    .ksel.m$n.i.type.m add command -label from\
    -command "ksel_setlabel .ksel.m$n.i.type from type,$n f"
    .ksel.m$n.i.type.m add command -label message-id\
    -command "ksel_setlabel .ksel.m$n.i.type msgid type,$n m"
    .ksel.m$n.i.type.m add command -label <crossposts\
    -command "ksel_setlabel .ksel.m$n.i.type <crossposts type,$n c"
    .ksel.m$n.i.type.m add command -label >crossposts\
    -command "ksel_setlabel .ksel.m$n.i.type >crossposts type,$n C"
    .ksel.m$n.i.type.m add command -label <lines\
    -command "ksel_setlabel .ksel.m$n.i.type <lines type,$n l"
    .ksel.m$n.i.type.m add command -label >lines\
    -command "ksel_setlabel .ksel.m$n.i.type >lines type,$n L"
    .ksel.m$n.i.type.m add command -label ignore\
    -command "ksel_setlabel .ksel.m$n.i.type ignore type,$n a"

    frame .ksel.m$n.chk \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    checkbutton .ksel.m$n.chk.regexp \
        -anchor w  \
        -relief raised -text {Regular expression} \
        -variable ksel(regexp,$n) -onvalue "/" -offvalue ""
    checkbutton .ksel.m$n.chk.case \
        -anchor w \
        -relief raised -text {Exact match} \
        -variable ksel(case,$n)  -onvalue "=" -offvalue ""
    frame .ksel.m$n.more \
        -borderwidth 1 -height 30 -relief sunken -width 30 
    button .ksel.m$n.more.or \
        -pady 0 -text or... -command "ksel_elem_new $n OR |"
    button .ksel.m$n.more.and \
        -pady 0 -text and...  -command "ksel_elem_new $n AND &"
    button .ksel.m$n.more.del \
        -padx 9 -pady 0 -text Delete \
	-command "ksel_destroy_elem .ksel.m$n $n"

    if {$n == 0} {
	pack .ksel.m$n \
	    -anchor center -expand 0 -fill x -side top
    } else {
	pack .ksel.m$n \
	    -anchor center -expand 0 -fill x -side top \
	    -after .ksel.m$m
    }
    pack .ksel.m$n.i \
        -anchor center -expand 0 -fill x -side top 
    if {$n != 0} {
	pack .ksel.m$n.i.con \
	    -anchor w -expand 0 -fill none -padx 4 -side left
    }
    pack .ksel.m$n.i.str \
        -anchor center -expand 1 -fill x -padx 3 -pady 3 -side left 
    pack .ksel.m$n.i.type \
        -anchor center -expand 0 -fill x -padx 4 -side left 
    pack .ksel.m$n.chk \
        -anchor center -expand 0 -fill x -side top 
    pack .ksel.m$n.chk.regexp \
        -anchor w -expand 0 -fill x -padx 5 -side left 
    pack .ksel.m$n.chk.case \
        -anchor e -expand 0 -fill x -padx 5 -side right 
    pack .ksel.m$n.more \
        -anchor center -expand 0 -fill x -padx 8 -side top 
    pack .ksel.m$n.more.or \
        -anchor w -expand 0 -fill none -side left 
    pack .ksel.m$n.more.and \
        -anchor w -expand 0 -fill none -side left 
    if {$n != 0} {
	pack .ksel.m$n.more.del \
	    -anchor e -expand 0 -fill none -side right
    }
    
    balloonHelp_traverse .ksel
}

proc ksel_window {args} {
global vTcl
    set cmd [lindex $args 0]
    set name [lindex $args 1]
    if {$name == "" || $cmd == ""} {return}
    set exists [winfo exists $name]
    switch $cmd {
        hide    { if $exists {wm withdraw $name; return} }
        unhide  { if $exists {wm deiconify $name; return} }
        iconify { if $exists {wm iconify $name; return} }
        destroy { if $exists {destroy $name; return} }
    }
}

proc ksel_destroyed {} {
    global ksel

    set ksel(listbox) -1
}
