#!/usr/local/bin/wish -f
#	Simple Balloon Help Package by
#	Robin Becker	robin@jessikat.demon.co.uk
#	Stewart Inglis	singlis@lucy.cs.waikato.ac.nz Fri Apr  4 08:57:43 1997
#	This is version 0.1
#       Modified Toivo Pedaste
#
#	Array indeces
#	a	appearances -1 for ever, 0 never, >0 a times
#	d	delay
#	k	kill delay
#	p,w	pending for widget w
#	a,w	appearances for widget w
#	k,w	auto kill time for widget w
#	m,w	the message for widget w
#	K,w	possible hanging kill after id
#	c	foreground
#	b	background

global balloon_v tcl_platform
set balloon_v(c) black
set balloon_v(b) #fffffa9fbdb1

set DEBUG 0

proc balloonHelp {w m args} {
    global balloon_v DEBUG Config

    if { $DEBUG } {
	puts "balloonHelp $w $m $args"
    }
    set balloon_v(cnt,$w) 0
    foreach { i v } $args  {
	switch -glob -- $i \
	    -d* { set balloon_v(d,$w) $v } \
	    -k* { set balloon_v(k,$w) $v } \
	    -a* { set balloon_v(a,$w) $v } \
	    default { error "bad args to balloonHelp" }
    }
    set balloon_v(m,$w) "$m"
    if {[string length $m] > 60} {
	set balloon_v(k,$w) [expr $Config(balloon_destroy_delay)*2]
    }
    set b [bind $w <Any-Enter>]
    if {![regexp "balloonHelp_show $w " $b]} {
	if {$b == ""} {
	    set b [bind [winfo class $w] <Any-Enter>]
	}
	if {"$b"!=""} {
	    set b "; $b"
	}
	bind $w <Any-Enter> "balloonHelp_show $w %W$b"
    }
    set b [bind $w <Any-Leave>]
    if {![regexp "balloonHelp_kill $w " $b]} {
	if {$b == ""} {
	    set b [bind [winfo class $w] <Any-Leave>]
	}
	if {"$b"!=""} {
	    set b "; $b"
	}
	bind $w <Any-Leave> "balloonHelp_kill $w 1 %W$b"
    }
}

proc balloonHelp_show {w W} {
    global balloon_v DEBUG Config TConfig
    if { $DEBUG } {
	puts "balloonHelp_show $w $W"
    }
    if {"$w"=="$W"} {
	catch { after cancel $balloon_v(K,$w);unset balloon_v(K,$w) }
	catch { after cancel $balloon_v(p,$w);unset balloon_v(p,$w) }
	if {[info exists balloon_v(a,$w)]} {
	    set a $balloon_v(a,$w)
	} else {
	    set a $Config(balloon_number)
	}
	if {$TConfig(balloon_on) != 0 &&
		    ($balloon_v(cnt,$w) <= $a || $a == -1)} {
	    if {[info exists balloon_v(d,$w)]} {
		set d $balloon_v(d,$w)
	    } else {
		set d $Config(balloon_start_delay)
	    }
	    if {[info exists balloon_v(k,$w)]} {
		set k $balloon_v(k,$w)
	    } else {
		set k $Config(balloon_destroy_delay)
	    }
	    if {[info exists balloon_v(0)]} {
		set d 0
		set balloon_v(p,$w) 0
		balloonHelp_show2 $w
	    } \
		else {
		    set balloon_v(p,$w) [after $d "balloonHelp_show2 $w"]
		}
	    set balloon_v(K,$w) [after [expr $d + $k] "balloonHelp_kill $w 0 $w"]
	}
    }
}

proc balloonHelp_show2 {w} {
    global balloon_v DEBUG
    if { $DEBUG } {
	puts "balloonHelp_show2 $w"
    }
    if {![info exists balloon_v(p,$w)]} return
    unset balloon_v(p,$w)
    catch	{
	set X [winfo rootx $w]
	set x [expr $X + [winfo width $w] -5]
	set Y [winfo rooty $w]
	set y [expr $Y + [winfo height $w]]
	balloonHelp_root $w

	toplevel $r -relief ridge -borderwidth 2 
	wm overrideredirect $r 1
	wm geometry $r +${x}+${y}
	pack [message $r.m -bg $balloon_v(b) -fg $balloon_v(c) -text "$balloon_v(m,$w)" -aspect 800]
	catch	{
	    tkwait vis $r
	    set ya [winfo rooty $r]
	    set yb [winfo height $r]
	    set g 0
	    if { [expr $ya+$yb] > [winfo screenheight $w] } {
		set g 1
		set y [expr $Y-$yb]
	    }
	    set xa [winfo rootx $r]
	    set xb [winfo width $r]
	    set xdiff [expr $xa + $xb - [winfo screenwidth $w]]
	    if {$xdiff > 0} {
		set g 1
		set x [expr $x - $xdiff]
	    }
	    if { $x < 0 } {
		set g 1
		set x 0
	    }
	    if { $g == 1 } {
		wm geometry $r +${x}+${y}
	    }
	    balloonHelp_delay
	}
	incr balloon_v(cnt,$w)
    }
}

proc balloonHelp_delay {} {
    global balloon_v DEBUG
    if { $DEBUG } {
	puts "balloonHelp_delay"
    }
    catch { after cancel $balloon_v(0);unset balloon_v(0) }
}

proc balloonHelp_kill {w m W} {
    global balloon_v DEBUG
    if { $DEBUG } {
	puts "balloonHelp_kill $w $m $W"
    }
    if {"$w"=="$W"} {
	catch { after cancel $balloon_v(K,$w);unset balloon_v(K,$w) }
	catch { after cancel $balloon_v(p,$w);unset balloon_v(p,$w) }
	balloonHelp_root $w
	balloonHelp_delay
	if {[winfo exists $r]} {
	    catch {destroy $r}
	    update idletasks
	    if {$m} {
		set balloon_v(0) [after 2000 balloonHelp_delay]
	    }
	}
    }
}

proc balloonHelp_hide {w} {
    global balloon_v DEBUG
    if { $DEBUG } {
	puts "balloonHelp_hide $w"
    }
    balloonHelp_root $w
    catch {unset balloon_v(p,$w) }
    catch {wm withdraw $r; update idletasks; destroy $r; update idletasks}
}

proc balloonHelp_root { w } {
    if { "$w" == "." } { set w {} }
    uplevel 1 set r $w.balloon
}

proc balloonHelp_traverse {w} {
#    puts $w
    set mess [option get $w bh {}]
    regsub -all {\\n} $mess "\n" mess
    if {$mess != ""} {
	balloonHelp $w $mess
    }
    foreach i [winfo children $w] {
	balloonHelp_traverse $i
    }
}

package provide balloonHelp 0.1
