#include "config.h"
#include "options.h"
#include "proto.h"
#include "nntp.h"


char *server_nntp;
char *auth_name;
char *different_newsrc = 0;
int silent = 0;
int nntp_progress_a = 0;
int group_list_unsub = 0;
int newsrc_only = 0;
static int pf_debug = 0;

extern int group_is_set ;
extern int last_copy_blank;
extern int nntp_failed;
extern int is_connected;
extern int try_again;
extern int nntp_debug;
extern char group_buf[];

FILE *f;

/* since we are linking with nntp.c need dummy
and substitute routines */

/* Dummy routines*/
suspend_nn()
{
}

group_header *lookup(name)
char *name;
{
}

void
user_delay(ticks)
int ticks;
{
}
void tprintf(va_alist)
va_dcl
{
}

char  
*tk(va_alist)
	va_dcl
{
}

char
*tk_set_var(var,n)
char *var,*n;
{
}

tk_nntp_start(button)
int button;
{
}

struct novgroup *
novstream(fp)
register FILE *fp;
{
}

void
tk_group_ent(gh,command)
group_header *gh;
char *command;
{
}

int
add_unread(gh, mode)
group_header *gh;
int mode;
{
}

/* Substitute routines */
FILE *tk_fdopen(fd, mode)
 int fd; char *mode;
{
  return fdopen(fd, mode);
}

int tk_fclose(file)
 FILE *file;
{
  return fclose(file);
}

char *
tk_fgets(str, size, file)
char *str;
int size;
FILE *file;
{
  char *p;

  if (str)
    p = fgets(str, size, file);
  else
    p = fgetstr(file);
  return p;
}

/*VARARGS*/
void nn_exitmsg(va_alist)
va_dcl
{
    char *fmt;
    int n;
    use_vararg;

    start_vararg;
    n = va_arg1(int);
    fmt = va_arg2(char *);
    vprintf(fmt, va_args3toN);
    end_vararg;
    exit(n);
}

void msg(va_alist)
va_dcl
{
    char *fmt;
    int n;

    if (pf_debug) {
      use_vararg;

      start_vararg;
      printf("pf ");
      fmt = va_arg1(char *);
      vprintf(fmt, va_args2toN);
      end_vararg;
      printf("\n");
    }
}

/* prefetch routines */
set_group(grp)
char *grp;
{
  int n;
  char buf[NNTP_STRLEN];	

  switch (n = ask_server(buf, "GROUP %s", grp)) {
  case OK_GROUP:
    group_is_set = 1;
    return 1;

  case ERR_NOGROUP:
    log_entry('N', "NNTP: group %s not found", grp);
    return -1;

  default:
    if (try_again) return 0;	/* Handle nntp server timeouts */
    log_entry('N', "GROUP %s response: %d", grp, n);
    break;

    if (!nntp_failed) {
      log_entry('N', "GROUP %s response: %d", grp, n);
      nntp_failed = 1;
    }
    return -1;
  }
}

int do_group(grp)
char *grp;
{
  again:
  if (!is_connected && connect_server() < 0) {
    return 0;
  }

  switch (set_group(grp)) {
  case -1:
    return ;
  case 0:
    goto again;	
  }
  return 1;
}

int
prefetch_group(grp, first, last, fname)
char *grp;
article_number first, last;
char *fname;
{
    FILE *tmp;
    int n;

again:
    switch (n = ask_server(NULL, "XOVER %d-%d", first, last)) {
     case OK_NOV:
	tmp = open_file(fname, OPEN_CREATE|MUST_EXIST);
	if (copy_text(tmp,"Overview ") < 0)
	    return 0;

	if (fclose(tmp) == EOF)
	  return 0;
	else 
	  return 1;	

     default:
	if (try_again) goto again; /* Handle nntp server timeouts */
	log_entry('N', "ARTICLE %ld %ld response: %d (in Group %s)",
                    (long)first, (long)last, n, grp);
	return 0;
    }
}

int
prefetch_article(grp, article, fname)
char *grp;
article_number article;
char *fname;
{
    FILE *tmp;
    int n;

again:
    switch (n = ask_server(NULL, "%s %ld", "ARTICLE", (long)article)) {
     case OK_ARTICLE:
	tmp = open_file(fname, OPEN_CREATE|MUST_EXIST);
	if (copy_text(tmp,"Article ") < 0)
	    return 0;

	if (!last_copy_blank)
	    fputc(NL_, tmp); /* add blank line after header */

	if (fclose(tmp) == EOF)
	  return 0;
	else 
	  return 1;	

     case ERR_NOARTIG:
     case ERR_NOART:
	return 0;

     default:
	if (try_again) goto again; /* Handle nntp server timeouts */
	log_entry('N', "ARTICLE %ld response: %d (in Group %s)",
                    (long)article, n, grp);
	return 0;
    }
}


int
main(argc, argv)
int argc;
char *argv[];
{
  static char pgroup[NNTP_STRLEN];
  char group[NNTP_STRLEN], fname[NNTP_STRLEN];
  int articlef, articlel, ok, n;
  FILE *result;
  char debug;

  if (argc <= 2) {
    fprintf(stderr,"Usage: nnprefetch nntp_server auth_file debug\n        Used by nn");
    exit(1);
  }
  
  nntp_debug  = 0;
  nn_directory = "";

  server_nntp = argv[1];
  auth_name = argv[2];
#ifdef TK  
  debug = argv[3][0];
  if (debug == 'b') {
    nntp_debug  = 1;
    pf_debug = 1;
  } else if (debug == 'p') {
     pf_debug = 1;
  } else if (debug == 'n') {   
    nntp_debug  = 1;
  }  
#endif

  result = fdopen(4,"w");
  nntp_check();
  nntp_fopen();

  while (!feof(stdin)) {
    n = scanf("%s %d %d %s", group, &articlef, &articlel,  fname);
    if (n <= 0)
      break;

    if (strcmp(group,pgroup)) {
      ok = do_group(group);
      strcpy(pgroup,group);
    }
    strcpy(group_buf, group);

    if (ok) {
      if (articlel)
	ok = prefetch_group(group,articlef,articlel,fname);
      else
	ok = prefetch_article(group,articlef,fname);
    }

    if (ok) {
      fprintf(result,"1 %s %d %d %s\n", group, articlef, articlel, fname);
      if (pf_debug)
	printf("pf 1 %s %d %d %s\n", group, articlef, articlel, fname);
    } else {
      fprintf(result,"0 %s %d %d %s\n", group, articlef, articlel, fname);
      if (pf_debug)
	printf("pf 0 %s %d %d %s\n", group, articlef, articlel, fname);
      pgroup[0] =  0;
    }
    fflush(result);
  }
}














