/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#define NAME "ipfwdump"
#define USAGE "[<savefile>] [<device>]"

#include <sys/types.h>
#include <sys/time.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <getopt.h>
#include <string.h>
#include <errno.h>
#include <sys/socket.h>

#include "inner.h"

#define BUFFER_SZ 65536
void *buffer = NULL;
char *savefile = "/usr/adm/ipfw.tcpdump";
char *devicefile = "/dev/netlink-firewall";

#define PCAP_MAGIC 0xa1b2c3d4
#define PCAP_VERSION_MAJOR 2

struct pcap_file_header {
  u_int32_t magic;
  u_int16_t version_major;
  u_int16_t version_minor;
    int32_t thiszone;
  u_int32_t sigfigs;
  u_int32_t snaplen;
  u_int32_t linktype;
};

struct pcap_null_pkthdr {
  struct timeval ts;
  u_int32_t caplen;
  u_int32_t len;
  u_int32_t af;
};

int main(int argc, char **argv)
{
  int i, in, out;
  struct pcap_null_pkthdr pkthdr;

  INIT(argc, argv);

  while ((i = getopt(argc, argv, STDOPTS_FLAGS)) != EOF) {
    switch(i) {
      STDOPTS_CASES
    };
  };

  if (optind < argc)
    savefile = argv[optind++];

  if (optind < argc)
    devicefile = argv[optind++];

  {
  struct pcap_file_header h;

  if ((out = open(savefile, O_RDONLY)) < 0) {
    if (errno != ENOENT) {
      lprintf(LP_SYSTEM, "open(\"%s\", O_RDONLY)", savefile);
      exit(1);
    };
    errno = 0;
    if ((out = open(savefile, O_WRONLY | O_APPEND | O_CREAT, 0600)) < 0) {
      lprintf(LP_SYSTEM, "open(\"%s\", O_WRONLY | O_APPEND | O_CREAT, 0600)", savefile);
      exit(1);
    };
    memset(&h, 0, sizeof(struct pcap_file_header));
    h.magic = PCAP_MAGIC;
    h.version_major = PCAP_VERSION_MAJOR;
    {
    struct timezone tz;
    if (gettimeofday(NULL, &tz) < 0) {
      lprintf(LP_SYSTEM, "gettimeofday(NULL, &tz)");
      exit(1);
    };
    h.thiszone = tz.tz_minuteswest / 60;
    };
    h.snaplen = BUFFER_SZ;
    if (write(out, &h, sizeof(struct pcap_file_header)) != sizeof(struct pcap_file_header)) {
      lprintf(LP_SYSTEM, "write");
      exit(1);
    };
  } else {
    if (read(out, &h, sizeof(struct pcap_file_header)) != sizeof(struct pcap_file_header)) {
      lprintf(LP_SYSTEM, "read", savefile);
      exit(1);
    };    
    if ((h.magic != PCAP_MAGIC) || (h.version_major < PCAP_VERSION_MAJOR) || h.linktype) {
      lprintf(LP_ERROR, "header from %s is invalid and/or incompatible with this program.", savefile);
      exit(1);
    };
    close(out);
    if ((out = open(savefile, O_WRONLY | O_APPEND)) < 0) {
      lprintf(LP_SYSTEM, "open(\"%s\", O_WRONLY | O_APPEND)", savefile);
      exit(1);
    };
  };
  };

  if ((in = open(devicefile, O_RDONLY)) < 0) {
    lprintf(LP_SYSTEM, "open(\"%s\", O_RDONLY)", devicefile);
    exit(1);
  };

  if (!(buffer = malloc(BUFFER_SZ))) {
    lprintf(LP_SYSTEM, "malloc(%d)", BUFFER_SZ);
    exit(1);
  };

  memset(&pkthdr, 0, sizeof(struct pcap_null_pkthdr));
  pkthdr.af = htonl(AF_INET);

  while(1) {
#if DEBUG
    if (debug)
      memset(buffer, 0, BUFFER_SZ);
#endif /* DEBUG */
    if ((i = read(in, buffer, BUFFER_SZ)) < 0) {
      lprintf(LP_SYSTEM, "read");
      exit(1);
    };
#if DEBUG
    if (debug)
      lprintf(LP_SYSTEM, "got a packet of length %d: %02x%02x%02x%02x...\n", myname, i, ((u_int8_t *)buffer)[0], ((u_int8_t *)buffer)[1], ((u_int8_t *)buffer)[2], ((u_int8_t *)buffer)[3]);
#endif /* DEBUG */
    if (gettimeofday(&pkthdr.ts, NULL) < 0) {
      lprintf(LP_SYSTEM, "gettimeofday(&pkthdr.ts, NULL)");
      exit(1);
    };
    pkthdr.caplen = pkthdr.len = i + 4;
    if (write(out, &pkthdr, sizeof(struct pcap_null_pkthdr)) != sizeof(struct pcap_null_pkthdr)) {
      lprintf(LP_SYSTEM, "write");
      exit(1);
    };
    if (write(out, buffer, i) != i) {
      lprintf(LP_SYSTEM, "write");
      exit(1);
    };
  };

  return 0;
};
