/*
%%% copyright-cmetz-98
This software is Copyright 1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#define NAME "ifi"
#define USAGE "[-n <name>] [-i <index>]"

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/socket.h>
#include <net/if.h>
#include <errno.h>
#if __linux__
#include <getopt.h>
#endif /* __linux__ */
#include <unistd.h>

#include "inner.h"

int main(int argc, char **argv)
{
  char *name;
  unsigned int index;
  int i, which = 0;

  INIT(argc, argv);
  
  while((i = getopt(argc, argv, STDOPTS_FLAGS "n:i:")) != -1) {
    switch(i) {
      case 'n':
	which |= 1;
        name = optarg;
        break;
      case 'i':
	which |= 2;
	if (!(index = atoi(optarg))) {
	  lprintf(LP_ERROR, "invalid interface index \"%s\"", optarg);
	  exit(1);
	};
	break;
      STDOPTS_CASES;
    };
  };

  switch(which) {
    case 0:
	{
        struct if_nameindex *nameindex;

	if (!(nameindex = if_nameindex())) {
	  lprintf(LP_SYSTEM, "if_nameindex");
	  exit(1);
	};

	for (i = 0; nameindex[i].if_index; i++) {
	  printf("record %d:\n", i);
	  printf("if_index:   %d\n", nameindex[i].if_index);
	  printf("if_name:    %s\n\n", nameindex[i].if_name);
	};

	if_freenameindex(nameindex);
	};
	break;
    case 1:
      if (!(index = if_nametoindex(name))) {
	  lprintf(LP_SYSTEM, "if_nametoindex(\"%s\")", name);
	  exit(1);
	};
	printf("%d\n", index);
	break;
    case 2:
	if (!(name = if_indextoname(index, NULL))) {
	  lprintf(LP_SYSTEM, "if_indextoname(%d)", index);
	  exit(1);
	};
	printf("%s\n", name);
	break;
    case 3:
	lprintf(LP_SYNTAX, "only one of -i and -n options may be used.");
	exit(1);
  };

  return 0;
};
