/*
%%% copyright-cmetz-98
This software is Copyright 1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/

#define NAME "etherudp"
#define USAGE "[-f tapfile] farhost:farservice localhost:localservice"

#include <sys/types.h>
#include <stdio.h>
#include <signal.h>
#include <string.h>
#include <errno.h>
#if __linux__
#include <getopt.h>
#endif /* __linux__ */
#include <limits.h>
#include <syslog.h>
#include <fcntl.h>
#include <unistd.h>

#include <sys/socket.h>
#include <netdb.h>

#include "inner.h"

char packet[1536];

int main(int argc, char *argv[])
{
  int i, aflag = 0;
  int tapfd, udpfd;
  char *tapfile = "/dev/tap0";
  char *fhost, *fserv, *lhost, *lserv;
  ssize_t packetlen;

  INIT(argc, argv);

  while((i = getopt(argc, argv, STDOPTS_FLAGS "f")) != -1) {
    switch(i) {
      case 'f':
	tapfile = optarg;
	break;
      STDOPTS_CASES;
    }
  }

  if ((argc - optind) != 2)
    usage();

  if (!(fserv = strchr(fhost = argv[optind], ':')))
    usage();

  *fserv = 0;
  fserv++;

  optind++;

  if (!(lserv = strchr(lhost = argv[optind], ':')))
    usage();

  *lserv = 0;
  lserv++;

  if (!inner_debug)
    for (i = 2; i < sysconf(_SC_OPEN_MAX); i++)
      close(i);

  openlog(inner_myname, LOG_NDELAY | LOG_PID, LOG_DAEMON);
  if (!inner_debug) {
    inner_lprintf_opts_callback(inner_lprintf_callback_syslog);

    if ((i = open("/dev/null", O_RDWR)) < 0) {
      lprintf(LP_SYSTEM, "open(\"/dev/null\", O_RDWR)");
      exit(1);
    };

    {
    int j;

    for (j = 0; j < 3; j++) {
      close(j);
      if (dup2(i, j) < 0) {
        lprintf(LP_SYSTEM, "dup2(%d, %d)", i, j);
	exit(1);
      };
    };
    };

    close(i);

    if (fork())
      exit(1);

    setsid();
  };

  if ((tapfd = open(tapfile, O_RDWR)) < 0) {
    lprintf(LP_SYSTEM, "open(\"%s\", O_RDWR)", tapfile);
    exit(1);
  };

  {
    struct addrinfo *ai, *ai2, req;

    memset(&req, 0, sizeof(struct addrinfo));
    req.ai_socktype = SOCK_DGRAM;

    if (i = getaddrinfo(fhost, fserv, &req, &ai)) {
      lprintf(LP_ERROR, "getaddrinfo(%s, %s, ...): %s(%d)", fhost, fserv, gai_strerror(i), i);
      exit(1);
    };

    if (ai->ai_next) {
      lprintf(LP_ERROR, "getaddrinfo(%s, %s, ...) returned multiple records", fhost, fserv);
      exit(1);
    };

    req.ai_family = ai->ai_family;

    if (i = getaddrinfo(lhost, lserv, &req, &ai2)) {
      lprintf(LP_ERROR, "getaddrinfo(%s, %s, ...): %s(%d)", lhost, lserv, gai_strerror(i), i);
      exit(1);
    };

    if (ai2->ai_next) {
      lprintf(LP_ERROR, "getaddrinfo(%s, %s, ...) returned multiple records", lhost, lserv);
      exit(1);
    };

    if ((udpfd = socket(ai->ai_family, ai->ai_socktype, ai->ai_protocol)) < 0) {
      lprintf(LP_SYSTEM, "socket(%d, %d %s)", ai->ai_family, ai->ai_socktype, ai->ai_protocol);
      exit(1);
    };

    if (bind(udpfd, ai2->ai_addr, ai2->ai_addrlen) < 0) {
      lprintf(LP_SYSTEM, "bind(...)");
      exit(1);
    };

    if (connect(udpfd, ai->ai_addr, ai->ai_addrlen) < 0) {
      lprintf(LP_SYSTEM, "connect(...)");
      exit(1);
    };

    freeaddrinfo(ai2);
    freeaddrinfo(ai);
  };

  {
    int maxfd;
    fd_set fds, rfds;

    FD_ZERO(&fds);
    FD_SET(tapfd, &fds);
    FD_SET(udpfd, &fds);

    if (tapfd > udpfd)
      maxfd = tapfd + 1;
    else
      maxfd = udpfd + 1;

    while(1) {
      rfds = fds;

      if (select(maxfd, &rfds, NULL, NULL, NULL) < 0) {
        lprintf(LP_SYSTEM, "select(...)");
        exit(1);
      };

      if (FD_ISSET(udpfd, &rfds)) {
	if ((packetlen = read(udpfd, packet, sizeof(packet))) < 0) {
          lprintf(LP_SYSTEM, "read(udpfd, ...)");
          exit(1);
	};

	if (write(tapfd, packet, packetlen) != packetlen) {
          lprintf(LP_SYSTEM, "write(tapfd(%d), ...)", tapfd);
          exit(1);
	};
      };

      if (FD_ISSET(tapfd, &rfds)) {
	if ((packetlen = read(tapfd, packet, sizeof(packet))) < 0) {
          lprintf(LP_SYSTEM, "read(tapfd, ...)");
          exit(1);
	};

	if (write(udpfd, packet, packetlen) != packetlen) {
          lprintf(LP_SYSTEM, "write(udpfd, ...)");
          exit(1);
	};
      };
    };
  };
};
