/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>
#include <stdlib.h>
#include <errno.h>

#include "inner.h"

char *inner_writenetline_eol = "\r\n";
int inner_writenetline_log = 0;

int inner_writenetline(int fd, char *buf, struct inner_netline_state **state)
{
  int i = strlen(buf), j;

  if (!*state) {
    if (!(*state = malloc(sizeof(struct inner_netline_state))))
      return -1;
    memset(*state, 0, sizeof(struct inner_netline_state));
  };

  if (i >= LINEBUF_SZ - 3) {
    if (inner_writenetline_log)
      inner_lprintf(INNER_LPRINTF_INFO, ">! line too long, tossing: %s", buf);
    return -1;
  };

  memcpy((*state)->linebuf, buf, i);
  memcpy((*state)->linebuf + i, inner_writenetline_eol, strlen(inner_writenetline_eol)); 

  (*state)->len = i + strlen(inner_writenetline_eol);

  if ((j = write(fd, (*state)->linebuf, (*state)->len)) != (*state)->len) {
    if (inner_writenetline_log)
      inner_lprintf(INNER_LPRINTF_INFO, ">! %s(%d), tossing: %s", strerror(errno), errno, buf);
    return -1;
  };

  if (inner_writenetline_log)
    inner_lprintf(INNER_LPRINTF_INFO, ">= %s", buf);

  return i;
};
