/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>
#include <stdlib.h>
#include <assert.h>

#include "inner.h"

void *inner_realloc(void *p, int len)
{
  static void *ap = NULL;
  static int alen = 0;

  if (!ap)
    return (ap = malloc(alen = len * 16));

  assert(p == ap);

  if (len < alen)
    return ap;

  if (ap = malloc(len * 4)) {
    memcpy(ap, p, alen);
    alen = len * 4;
  };

  return ap;
};
