/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>

#include "inner.h"

char *inner_readnetline_eol = "\r\n";
int inner_readnetline_log = 0;

int inner_readnetline(int fd, char *buf, struct inner_netline_state **state)
{
  char *c;
  int i, j;

  if (!*state) {
    if (!(*state = malloc(sizeof(struct inner_netline_state))))
      return -1;
    memset(*state, 0, sizeof(struct inner_netline_state));
  };

checkeol:
  for (i = 0; i < (*state)->len; i++)
    if (!(*state)->linebuf[i])
      (*state)->linebuf[i] = ' ';

  (*state)->linebuf[(*state)->len] = 0;

  if (c = strstr((*state)->linebuf, inner_readnetline_eol)) {
    if ((*state)->tossline) {
      (*state)->tossline = (*state)->len = 0;
    } else {
      *c = 0; 
      i = c - (*state)->linebuf;
      c += strlen(inner_readnetline_eol);

      strcpy(buf, (*state)->linebuf);
      memmove((*state)->linebuf, c, (*state)->len -= i);

      if (inner_readnetline_log)
        inner_lprintf(INNER_LPRINTF_INFO, "<= %s", buf);

      return i;
    };
  };

  if ((i = LINEBUF_SZ - 1 - (*state)->len) <= 0) {
    if (inner_readnetline_log)
      inner_lprintf(INNER_LPRINTF_INFO, "<! buffer overrun, tossing: %s", (*state)->linebuf);

    (*state)->len = 0;
  };

  if ((j = read(fd, (*state)->linebuf + (*state)->len, i)) < 0) {
    if ((errno != EAGAIN) && (errno != EINTR)) {
      if (inner_readnetline_log)
        inner_lprintf(INNER_LPRINTF_INFO, "<! %s(%d), tossing: %s", strerror(errno), errno, (*state)->linebuf);
      (*state)->len = 0;
      return -1;
    };
  };

  (*state)->len += j;

  goto checkeol;
};
