/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>

#include "support.h"
#include "inner.h"

int inner_putvalue_hexthresh = 200;
int inner_putvalue_numbertoo = 0;

char *inner_putvalue(struct nrl_nametonum *tab, char *buffer, uint32_t val)
{
  static char buf[INNER_PUTVALUE_BUFLEN];
  char *c;

  if (!buffer)
    buffer = buf;

  if (tab && (c = nrl_numtoname(tab, val))) {
    if (inner_putvalue_numbertoo)
      snprintf(buffer, INNER_PUTVALUE_BUFLEN, (val >= inner_putvalue_hexthresh) ? "%s(0x%x)" : "%s(%d)", c, val);
    else
      strncpy(buffer, c, INNER_PUTVALUE_BUFLEN);
  } else
    snprintf(buffer, INNER_PUTVALUE_BUFLEN, (val >= inner_putvalue_hexthresh) ? "0x%x" : "%d", val);

  buffer[INNER_PUTVALUE_BUFLEN - 1] = 0;
  return buffer;
};
