/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>
#include <sys/stat.h>
#include <limits.h>
#include <errno.h>

#include "inner.h"

int inner_getvalue(struct nrl_nametonum *tab, char *in, uint32_t *out)
{
  if (tab) {
    int i;

    if ((i = nrl_nametonum(tab, in)) >= 0) {
      *out = i;
      return 0;
    };
  };

  {
    unsigned long l;
    char *c;

    if (((l = strtoul(in, &c, 0)) == ULONG_MAX) && (errno == ERANGE))
      return -1;

    if (!*c) {
      *out = l;
      return 0;
    };
  };

  return -1;
};
