/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>
#include <unistd.h>
#include <sys/stat.h>
#include <netdb.h>
#include <sys/socket.h>

#include "inner.h"

int inner_getpeer(char *peerbuf)
{
  char hbuf[NI_MAXHOST], sbuf[NI_MAXSERV];
  struct stat stat;
  int i;

  if (fstat(STDIN_FILENO, &stat) < 0) {
    inner_lprintf(INNER_LPRINTF_SYSTEM, "fstat");
    return -1;
  };

  if (S_ISSOCK(stat.st_mode)) {
    union sockaddr_union sa;

    i = sizeof(union sockaddr_union);
    if (getpeername(STDIN_FILENO, (struct sockaddr *)&sa, &i)) {
      inner_lprintf(INNER_LPRINTF_SYSTEM, "getpeername");
      return -1;
    };

    if (getnameinfo((struct sockaddr *)&sa, i, hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), NI_NUMERICHOST | NI_NUMERICSERV)) {
      inner_lprintf(INNER_LPRINTF_ERROR, "getnameinfo failed");
      return -1;
    };

    snprintf(peerbuf, PEERBUF_SZ, "%s.%s", hbuf, sbuf);
  } else {
    if (isatty(STDIN_FILENO)) {
      strcpy(peerbuf, "stdin");
      inner_readnetline_eol = "\n";
      inner_writenetline_eol = "\n";
    } else {
      inner_lprintf(INNER_LPRINTF_INTERNAL, "stdin is neither a socket nor a tty");
      return -1;
    };
  };

  return 0;
};

