/*
%%% copyright-cmetz-97
This software is Copyright 1997-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

#include "support.h"
#include "inner.h"

static char hextab[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

void inner_dump_sockaddr(struct sockaddr *sa, int len)
{
  char hbuf[NI_MAXHOST], sbuf[NI_MAXSERV];

  if (!len)
    len = SA_LEN(sa);

  inner_lprintf(INNER_LPRINTF_DEBUG, "len = %d, sa_len = %d, sa_family = %d", len, SA_LEN(sa), sa->sa_family);
  {
    int i = len;
    char *c = hbuf;
    u_int8_t *p = (u_int8_t *)sa->sa_data;

    i -= ((unsigned)sa->sa_data - (unsigned)sa);

    while(i--) {
      *(c++) = hextab[(*p & 0xf0) >> 4];
      *(c++) = hextab[(*(p++) & 0x0f)];
    }
    *c = 0;
  }
  inner_lprintf(INNER_LPRINTF_DEBUG, "sa_data = %s", hbuf);

  if ((sa->sa_family < AF_MAX) && SA_LEN(sa) && getnameinfo(sa, len, hbuf, sizeof(hbuf), sbuf, sizeof(sbuf), NI_NUMERICHOST | NI_NUMERICSERV)) {
    inner_lprintf(INNER_LPRINTF_DEBUG, "getnameinfo failed");
    return;
  };
  inner_lprintf(INNER_LPRINTF_DEBUG, "addr = %s, port = %s", hbuf, sbuf);
};
