/*
%%% copyright-cmetz-96
This software is Copyright 1996-1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#ifndef _INNER_H
#define _INNER_H 1

#include <stdint.h>
#include <stdio.h>

#define LINEBUF_SZ 1024
#define PEERBUF_SZ (NI_MAXHOST + NI_MAXSERV + 1)

struct inner_netline_state {
  int len;
  int tossline;
  char linebuf[LINEBUF_SZ];
};

struct inner_lprintf_callback {
  unsigned int mask;
  unsigned int flags;
  void (*print)(int type, char *message);
};

void inner_lprintf(int priority, char *format,...);
void inner_lprintf_opts_file(char *name, unsigned int *line);
void inner_lprintf_opts_source(char *filefunction, unsigned int line);
void inner_lprintf_opts_callback(struct inner_lprintf_callback *callback);
void inner_lprintf_opts_flags(unsigned int mask, unsigned int flags);

struct inner_lprintf_callback *inner_lprintf_callback_stdio;
struct inner_lprintf_callback *inner_lprintf_callback_syslog;

#define INNER_LPRINTF_INFO          -1
#define INNER_LPRINTF_WARNING       -2
#define INNER_LPRINTF_ERROR         -3
#define INNER_LPRINTF_SYNTAX        -4
#define INNER_LPRINTF_INTERNAL      -5
#define INNER_LPRINTF_SYSTEM        -6
#define INNER_LPRINTF_DEBUG         -7

#define INNER_LPRINTF_MYNAME        1
#define INNER_LPRINTF_SHOWDEBUG     2
#define INNER_LPRINTF_SHOWSOURCE    4

struct sockaddr;
void inner_dump_sockaddr(struct sockaddr *sa, int len);

void inner_free(void *p);

int inner_getpeer(char *peerbuf);

struct nrl_nametonum;
int inner_getvalue(struct nrl_nametonum *tab, char *in, uint32_t *out);

char *inner_putvalue(struct nrl_nametonum *tab, char *buffer, uint32_t val);
extern int inner_putvalue_hexthresh;
extern int inner_putvalue_numbertoo;
#define INNER_PUTVALUE_BUFLEN 64

int inner_readnetline(int fd, char *buf, struct inner_netline_state **state);
extern char *inner_readnetline_eol;
extern int inner_readnetline_log;

/* void *inner_realloc(void *p, int len); */

int inner_writenetline(int fd, char *buf, struct inner_netline_state **state);
extern char *inner_writenetline_eol;
extern int inner_writenetline_log;

extern char *inner_myname;
extern int inner_debug;

#ifdef NAME
#define INIT(argc, argv) \
  { \
    char *__c; \
    \
    if ((__c = strrchr(argv[0], '/'))) \
      inner_myname = strdup(++__c); \
    else \
      inner_myname = strdup(argv[0]); \
  };

#if DEBUG
#define STDOPTS_FLAGS "Vhd"
#define STDOPTS_CASES \
        case 'd': \
	  inner_debug++; \
          inner_lprintf_opts_flags(INNER_LPRINTF_SHOWDEBUG, INNER_LPRINTF_SHOWDEBUG); \
	  break; \
        case 'h': \
          inner_usage(); \
        case 'V': \
	  printf("%s: " NAME " version " VERSION "\n", inner_myname); \
	  exit(0); \
        default: \
          inner_usage();

static void inner_usage()
{
  fprintf(stderr, "usage: %s [-Vhd] " USAGE "\n", inner_myname);
  exit(1);
};
#else /* DEBUG */
#define STDOPTS_FLAGS "Vh"
#define STDOPTS_CASES \
        case 'h': \
          inner_usage(); \
        case 'V': \
	  printf("%s: " NAME " version " VERSION "\n", inner_myname); \
	  exit(0); \
        default: \
          inner_usage();

static void inner_usage()
{
  fprintf(stderr, "usage: %s [-Vh] " USAGE "\n", inner_myname);
  exit(1);
};
#endif /* DEBUG */
#endif /* VERSION */

#if !INNER_NOSHORT
#define addrcmp inner_addrcmp
#define free inner_free
/* #define realloc inner_realloc */

#if DEBUG
#if defined(__GNUC__) && (__GNUC__ >= 2)
#define lprintf inner_lprintf_opts_source(__FILE__ ":" __FUNCTION__, __LINE__), inner_lprintf
#else /* defined(__GNUC__) && (__GNUC__ >= 2) */
#define lprintf inner_lprintf_opts_source(__FILE__, __LINE__), inner_lprintf
#endif /* defined(__GNUC__) && (__GNUC__ >= 2) */
#else /* DEBUG */
#define lprintf inner_lprintf
#endif /* DEBUG */

#define dump_sockaddr inner_dump_sockaddr
#define readnetline inner_readnetline
#define writenetline inner_writenetline
#define getpeer inner_getpeer
#define getvalue inner_getvalue
#define putvalue inner_putvalue

#define putvalue_hexthresh inner_putvalue_hexthresh
#define putvalue_numbertoo inner_putvalue_numbertoo
#define readnetline_log inner_readnetline_log
#define myname inner_myname
#if DEBUG
#define debug inner_debug
#endif /* DEBUG */
#define usage inner_usage

#define LP_INFO          INNER_LPRINTF_INFO
#define LP_WARNING       INNER_LPRINTF_WARNING
#define LP_ERROR         INNER_LPRINTF_ERROR
#define LP_SYNTAX        INNER_LPRINTF_SYNTAX
#define LP_INTERNAL      INNER_LPRINTF_INTERNAL
#define LP_SYSTEM        INNER_LPRINTF_SYSTEM
#define LP_DEBUG         INNER_LPRINTF_DEBUG

#define PUTVALUE_BUFLEN  INNER_PUTVALUE_BUFLEN
#endif /* !INNER_NOSHORT */
#endif /* _INNER_H 1 */
