/*
%%% portions-copyright-cmetz-96
Portions of this software are Copyright 1996-1998 by Craig Metz, All Rights
Reserved. The Inner Net License Version 2 applies to these portions of
the software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

%%% copyright-nrl-95
This software is Copyright 1995-1998 by Randall Atkinson, Ronald Lee,
Daniel McDonald, Bao Phan, and Chris Winters. All Rights Reserved. All
rights under this copyright have been assigned to the US Naval Research
Laboratory (NRL). The NRL Copyright Notice and License Agreement Version
1.1 (January 17, 1995) applies to this software.
You should have received a copy of the license with this software. If you
didn't get a copy, you may request one from <license@ipv6.nrl.navy.mil>.

*/

#include <sys/param.h>
#include <sys/socket.h>
#ifndef linux
#include <machine/endian.h>
#endif /* linux */

#include <netinet/in.h>
#ifndef linux
#include <netns/ns.h>
#ifndef __FreeBSD__
#include <netiso/iso.h>
#endif /* __FreeBSD__ */
#include <net/if_dl.h>
#endif /* linux */

#include <ctype.h>
#include <string.h>
#include <stdio.h>

/*
   Convert:

   xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx
   xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:ddd.ddd.ddd.ddd
   xxxx::xxxx:xxxx
   xxxx::ddd.ddd.ddd.ddd
   ::xxxx:xxxx
   ::ddd.ddd.ddd.ddd 
*/

#define UNKNOWN 0
#define COLON 1
#define DOT 2

#if INET6
/* Parse a IPv6 address in string form (probably human-entered) into a binary,
   network-order address. Be fairly strict about syntax. Note: handles the
   double colon case by building a ``left'' and ``right'' side address, then
   effectively shifting over the right side to the far right of its buffer
   and merging that with the left side. */
static int __inet6_pton(const char *cp, struct in6_addr *ap)
{
  char left[sizeof(struct in6_addr)], right[sizeof(struct in6_addr)];
  char *leftpos = left, *rightpos = right;
  char **pos = &leftpos;

  int state = UNKNOWN;
  char temp[5];
  int tempi = 0;
  int bytesdone = 0;
  int dotsdone = 0;

  memset(left, 0, sizeof(struct in6_addr));
  memset(right, 0, sizeof(struct in6_addr));

  while (*cp) {
    switch (*cp) {
    case 'a':
    case 'b':
    case 'c':
    case 'd':
    case 'e':
    case 'f':
    case 'A':
    case 'B':
    case 'C':
    case 'D':
    case 'E':
    case 'F':
      if (state == DOT)
	return 0;
    case '0':
    case '1':
    case '2':
    case '3':
    case '4':
    case '5':
    case '6':
    case '7':
    case '8':
    case '9':
      /* Buffer digits */
      if (tempi > sizeof(temp) - 2)
        return 0;
      temp[tempi++] = *(cp++);
      break;
    case ':': /* Handle (hex) digits before a colon */
      if (tempi) {
	if (state == DOT)
	  return 0;
	tempi = temp[tempi] = 0;
	{
          char *end;
	  unsigned int buf = strtoul(temp, &end, 16);
          if ((end == temp) || (buf > 0xffff))
            return 0;
	  *((short *)(*pos)) = htons((short)buf);
	}
	*pos += sizeof(short);
	bytesdone += 2;
      } else /* Handle the icky double-colon case */
	if (state == COLON) {
	  if (rightpos == right) {
	    pos = &rightpos;
            if (!*(cp + 1))
              rightpos++;
	  } else
	    return 0;
	}
		
      state = COLON;
      cp++;
      break;
    case '.': /* Handle (decimal) digits before a dot. Does not handle
	         case where there are hex digits in there properly, so
		 an address like f00:dead:beef:fe.1.1.9 right */
      if (!tempi)
	return 0;

      tempi = temp[tempi] = 0;
      {
        char *end;
	unsigned int buf = strtoul(temp, &end, 10);
        if ((end == temp) || (buf > 0xff))
          return 0;
	*((char *)(*pos)) = (char)buf;
      }
      ++*pos;
      bytesdone++;
      dotsdone++;
      state = DOT;
      cp++;
      break;
    default:
      return 0;
    }
  }
  /* Finish up the last block of digits */
  if (tempi) 
    switch(state) {
    case COLON:
      tempi = temp[tempi] = 0;
      {
        char *end;
	unsigned int buf = strtoul(temp, &end, 16);
        if ((end == temp) || (buf > 0xffff))
          return 0;
	*((short *)(*pos)) = htons((short)buf);
      }
      *pos += sizeof(short);
      bytesdone += 2;
      break;
    case DOT:
      tempi = temp[tempi] = 0;
      {
        char *end;
	unsigned int buf = strtoul(temp, &end, 10);
        if ((end == temp) || (buf > 0xff))
          return 0;
	*((char *)(*pos)) = (char)buf;
      }
      ++*pos;
      bytesdone++;
      dotsdone++;
      break;
    default:
      return 0;
    }

  /* Check to see if it looks like we handled a reasonable number of tokens */
  if ((dotsdone && (dotsdone != 4)) || ((rightpos == right) &&
      (bytesdone != sizeof(struct in6_addr))))
    return 0;

  /* Copy the new address to the buffer given, merging the left and right
     sides created by the double colon case */
  memset(ap, 0, sizeof(struct in6_addr));
  memcpy(ap, left, leftpos - left);
  memcpy((void *)ap + sizeof(struct in6_addr) - (rightpos - right), right, rightpos - right);

  return 1;
}
#endif /* INET6 */

#if inet_pton == __inet_pton
#undef inet_pton
int __inet_pton(int af, const char *cp, void *ap)
{
  return inet_pton(af, cp, ap);
};
#endif /* inet_pton == __inet_pton */

int inet_pton(int af, const char *cp, void *ap)
{
  char addr[16], *addrptr;
  int addrlen;
#ifndef linux
  struct ns_addr addrns;
#endif /* linux */

  addrlen = 0;
  addrptr = addr;

  switch(af) {
  case AF_INET:
    if (inet_aton(cp, (struct in_addr *)addr))
      addrlen = sizeof(struct in_addr);
    break;

#if INET6
  case AF_INET6:
    if (__inet6_pton(cp, (struct in6_addr *)addr))
      addrlen = sizeof(struct in6_addr);
    break;
#endif /* INET6 */

#ifndef linux
#if defined(AF_ISO) && !__FreeBSD__
  case AF_ISO:
    addrptr = (char *)iso_addr(cp); 
    if (addrptr) 
      addrlen = sizeof(struct iso_addr);
    break;
#endif /* defined(AF_ISO) && !__FreeBSD__ */

#ifdef AF_NS
  case AF_NS:
    addrns = ns_addr(cp);
    addrptr = (char *)&addrns;
    addrlen = sizeof(struct ns_addr);
    break;
#endif /* AF_NS */

#ifdef AF_LINK
  case AF_LINK:
    link_addr(cp, (struct sockaddr_dl *)addr);
    addrlen = sizeof(struct sockaddr_dl);
    break;
#endif /* AF_LINK */
#endif /* linux */
  }

  if (addrlen) {
    memcpy(ap, addrptr, addrlen);
    return addrlen;
  } else
    return -1;
}
