/*
%%% copyright-cmetz-98
This software is Copyright 1998 by Craig Metz, All Rights Reserved.
The Inner Net License Version 2 applies to this software.
You should have received a copy of the license with this software. If
you didn't get a copy, you may request one from <license@inner.net>.

*/
#include <sys/types.h>
#include <stdlib.h>
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <net/if.h>
#ifdef AF_LINK
#include <net/if_dl.h>
#endif /* AF_LINK */
#include <errno.h>

#include "support.h"

/* #undef SIOCGIFINDEX */

unsigned int if_nametoindex(const char *name)
{
  int i, fd;
#ifdef SIOCGIFINDEX
  struct ifreq ifreq;
#else /* SIOCGIFINDEX */
  struct ifconf ifconf;
  void *p;
  int len;
  char lastname[IFNAMSIZ + 1], *thisname;
  unsigned int index = 0;
#endif /* SIOCGIFINDEX */

  if ((fd = socket(PF_INET, SOCK_DGRAM, 0)) < 0)
    return 0;

#ifdef SIOCGIFINDEX
  strcpy(ifreq.ifr_name, name);
  i = ioctl(fd, SIOCGIFINDEX, &ifreq);
  close(fd);
  if (i)
    return 0;

  return ifreq.ifr_ifindex;
#else /* SIOCGIFINDEX */
  if (__siocgifconf(fd, &ifconf)) {
    close(fd);
    return 0;
  };

  i = 0;
  p = ifconf.ifc_buf;
  len = ifconf.ifc_len;
  lastname[0] = 0;
  lastname[IFNAMSIZ] = 0;

  while(len > 0) {
    if (len < (IFNAMSIZ + sizeof(struct sockaddr)))
      goto ret;

    if (strncmp(lastname, thisname = p, IFNAMSIZ)) {
      if (!strcmp(lastname, name)) {
	index = i;
	goto ret;
      };
      memcpy(lastname, thisname, IFNAMSIZ);
      i++;
    };

    len -= IFNAMSIZ;
    p += IFNAMSIZ;

#ifdef AF_LINK
    if (!strncmp(thisname, name, IFNAMSIZ) && (((struct sockaddr *)p)->sa_family == AF_LINK)) {
      index = ((struct sockaddr_dl *)p)->sdl_index;
      goto ret;
    };
#endif /* AF_LINK */

    if (len < SA_LEN((struct sockaddr *)p))
      goto ret;
    len -= SA_LEN((struct sockaddr *)p);
    p += SA_LEN((struct sockaddr *)p);
  };

  if (!strcmp(lastname, name))
    index = i;

ret:
  close(fd);
  free(ifconf.ifc_buf);
  return index;
#endif /* SIOCGIFINDEX */
};
